<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleResult_V3 StructType
 * @subpackage Structs
 */
class VehicleResult_V3 extends Vehicle
{
    /**
     * The VehicleTransicsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VehicleTransicsID;
    /**
     * The Modified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modified;
    /**
     * The CurrentKms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CurrentKms;
    /**
     * The FuelLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevel;
    /**
     * The FuelLevelIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevelIndex;
    /**
     * The RefrigeratorIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RefrigeratorIndex;
    /**
     * The ActivityCompleted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ActivityCompleted;
    /**
     * The LastTrailerCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastTrailerCode;
    /**
     * The Site
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierResult
     */
    public $Site;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $CoDriver;
    /**
     * The ObcInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleObcInfo
     */
    public $ObcInfo;
    /**
     * The ETAInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleETAInfo
     */
    public $ETAInfo;
    /**
     * The TemperatureInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleTemperatureInfo
     */
    public $TemperatureInfo;
    /**
     * The InfoFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleInfoFields
     */
    public $InfoFields;
    /**
     * The UpdateDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleUpdateDates
     */
    public $UpdateDates;
    /**
     * The VehicleCostInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleCostInfo
     */
    public $VehicleCostInfo;
    /**
     * The NextStopInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NextStopResult
     */
    public $NextStopInfo;
    /**
     * The FormattedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormattedName;
    /**
     * Constructor method for VehicleResult_V3
     * @uses VehicleResult_V3::setVehicleTransicsID()
     * @uses VehicleResult_V3::setModified()
     * @uses VehicleResult_V3::setCurrentKms()
     * @uses VehicleResult_V3::setFuelLevel()
     * @uses VehicleResult_V3::setFuelLevelIndex()
     * @uses VehicleResult_V3::setRefrigeratorIndex()
     * @uses VehicleResult_V3::setActivityCompleted()
     * @uses VehicleResult_V3::setLastTrailerCode()
     * @uses VehicleResult_V3::setSite()
     * @uses VehicleResult_V3::setPosition()
     * @uses VehicleResult_V3::setActivity()
     * @uses VehicleResult_V3::setDriver()
     * @uses VehicleResult_V3::setCoDriver()
     * @uses VehicleResult_V3::setObcInfo()
     * @uses VehicleResult_V3::setETAInfo()
     * @uses VehicleResult_V3::setTemperatureInfo()
     * @uses VehicleResult_V3::setInfoFields()
     * @uses VehicleResult_V3::setUpdateDates()
     * @uses VehicleResult_V3::setVehicleCostInfo()
     * @uses VehicleResult_V3::setNextStopInfo()
     * @uses VehicleResult_V3::setFormattedName()
     * @param int $vehicleTransicsID
     * @param string $modified
     * @param int $currentKms
     * @param int $fuelLevel
     * @param int $fuelLevelIndex
     * @param int $refrigeratorIndex
     * @param bool $activityCompleted
     * @param string $lastTrailerCode
     * @param \StructType\IdentifierResult $site
     * @param \StructType\PositionResult $position
     * @param \StructType\Activity $activity
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @param \StructType\VehicleObcInfo $obcInfo
     * @param \StructType\VehicleETAInfo $eTAInfo
     * @param \StructType\VehicleTemperatureInfo $temperatureInfo
     * @param \StructType\VehicleInfoFields $infoFields
     * @param \StructType\VehicleUpdateDates $updateDates
     * @param \StructType\VehicleCostInfo $vehicleCostInfo
     * @param \StructType\NextStopResult $nextStopInfo
     * @param string $formattedName
     */
    public function __construct($vehicleTransicsID = null, $modified = null, $currentKms = null, $fuelLevel = null, $fuelLevelIndex = null, $refrigeratorIndex = null, $activityCompleted = null, $lastTrailerCode = null, \StructType\IdentifierResult $site = null, \StructType\PositionResult $position = null, \StructType\Activity $activity = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierPerson_V2 $coDriver = null, \StructType\VehicleObcInfo $obcInfo = null, \StructType\VehicleETAInfo $eTAInfo = null, \StructType\VehicleTemperatureInfo $temperatureInfo = null, \StructType\VehicleInfoFields $infoFields = null, \StructType\VehicleUpdateDates $updateDates = null, \StructType\VehicleCostInfo $vehicleCostInfo = null, \StructType\NextStopResult $nextStopInfo = null, $formattedName = null)
    {
        $this
            ->setVehicleTransicsID($vehicleTransicsID)
            ->setModified($modified)
            ->setCurrentKms($currentKms)
            ->setFuelLevel($fuelLevel)
            ->setFuelLevelIndex($fuelLevelIndex)
            ->setRefrigeratorIndex($refrigeratorIndex)
            ->setActivityCompleted($activityCompleted)
            ->setLastTrailerCode($lastTrailerCode)
            ->setSite($site)
            ->setPosition($position)
            ->setActivity($activity)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setObcInfo($obcInfo)
            ->setETAInfo($eTAInfo)
            ->setTemperatureInfo($temperatureInfo)
            ->setInfoFields($infoFields)
            ->setUpdateDates($updateDates)
            ->setVehicleCostInfo($vehicleCostInfo)
            ->setNextStopInfo($nextStopInfo)
            ->setFormattedName($formattedName);
    }
    /**
     * Get VehicleTransicsID value
     * @return int
     */
    public function getVehicleTransicsID()
    {
        return $this->VehicleTransicsID;
    }
    /**
     * Set VehicleTransicsID value
     * @param int $vehicleTransicsID
     * @return \StructType\VehicleResult_V3
     */
    public function setVehicleTransicsID($vehicleTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleTransicsID) && !is_numeric($vehicleTransicsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vehicleTransicsID)), __LINE__);
        }
        $this->VehicleTransicsID = $vehicleTransicsID;
        return $this;
    }
    /**
     * Get Modified value
     * @return string
     */
    public function getModified()
    {
        return $this->Modified;
    }
    /**
     * Set Modified value
     * @param string $modified
     * @return \StructType\VehicleResult_V3
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modified)), __LINE__);
        }
        $this->Modified = $modified;
        return $this;
    }
    /**
     * Get CurrentKms value
     * @return int
     */
    public function getCurrentKms()
    {
        return $this->CurrentKms;
    }
    /**
     * Set CurrentKms value
     * @param int $currentKms
     * @return \StructType\VehicleResult_V3
     */
    public function setCurrentKms($currentKms = null)
    {
        // validation for constraint: int
        if (!is_null($currentKms) && !is_numeric($currentKms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentKms)), __LINE__);
        }
        $this->CurrentKms = $currentKms;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\VehicleResult_V3
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !is_numeric($fuelLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get FuelLevelIndex value
     * @return int
     */
    public function getFuelLevelIndex()
    {
        return $this->FuelLevelIndex;
    }
    /**
     * Set FuelLevelIndex value
     * @param int $fuelLevelIndex
     * @return \StructType\VehicleResult_V3
     */
    public function setFuelLevelIndex($fuelLevelIndex = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevelIndex) && !is_numeric($fuelLevelIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuelLevelIndex)), __LINE__);
        }
        $this->FuelLevelIndex = $fuelLevelIndex;
        return $this;
    }
    /**
     * Get RefrigeratorIndex value
     * @return int
     */
    public function getRefrigeratorIndex()
    {
        return $this->RefrigeratorIndex;
    }
    /**
     * Set RefrigeratorIndex value
     * @param int $refrigeratorIndex
     * @return \StructType\VehicleResult_V3
     */
    public function setRefrigeratorIndex($refrigeratorIndex = null)
    {
        // validation for constraint: int
        if (!is_null($refrigeratorIndex) && !is_numeric($refrigeratorIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($refrigeratorIndex)), __LINE__);
        }
        $this->RefrigeratorIndex = $refrigeratorIndex;
        return $this;
    }
    /**
     * Get ActivityCompleted value
     * @return bool
     */
    public function getActivityCompleted()
    {
        return $this->ActivityCompleted;
    }
    /**
     * Set ActivityCompleted value
     * @param bool $activityCompleted
     * @return \StructType\VehicleResult_V3
     */
    public function setActivityCompleted($activityCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($activityCompleted) && !is_bool($activityCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($activityCompleted)), __LINE__);
        }
        $this->ActivityCompleted = $activityCompleted;
        return $this;
    }
    /**
     * Get LastTrailerCode value
     * @return string|null
     */
    public function getLastTrailerCode()
    {
        return $this->LastTrailerCode;
    }
    /**
     * Set LastTrailerCode value
     * @param string $lastTrailerCode
     * @return \StructType\VehicleResult_V3
     */
    public function setLastTrailerCode($lastTrailerCode = null)
    {
        // validation for constraint: string
        if (!is_null($lastTrailerCode) && !is_string($lastTrailerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastTrailerCode)), __LINE__);
        }
        $this->LastTrailerCode = $lastTrailerCode;
        return $this;
    }
    /**
     * Get Site value
     * @return \StructType\IdentifierResult|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\IdentifierResult $site
     * @return \StructType\VehicleResult_V3
     */
    public function setSite(\StructType\IdentifierResult $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\VehicleResult_V3
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\VehicleResult_V3
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\VehicleResult_V3
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @return \StructType\VehicleResult_V3
     */
    public function setCoDriver(\StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get ObcInfo value
     * @return \StructType\VehicleObcInfo|null
     */
    public function getObcInfo()
    {
        return $this->ObcInfo;
    }
    /**
     * Set ObcInfo value
     * @param \StructType\VehicleObcInfo $obcInfo
     * @return \StructType\VehicleResult_V3
     */
    public function setObcInfo(\StructType\VehicleObcInfo $obcInfo = null)
    {
        $this->ObcInfo = $obcInfo;
        return $this;
    }
    /**
     * Get ETAInfo value
     * @return \StructType\VehicleETAInfo|null
     */
    public function getETAInfo()
    {
        return $this->ETAInfo;
    }
    /**
     * Set ETAInfo value
     * @param \StructType\VehicleETAInfo $eTAInfo
     * @return \StructType\VehicleResult_V3
     */
    public function setETAInfo(\StructType\VehicleETAInfo $eTAInfo = null)
    {
        $this->ETAInfo = $eTAInfo;
        return $this;
    }
    /**
     * Get TemperatureInfo value
     * @return \StructType\VehicleTemperatureInfo|null
     */
    public function getTemperatureInfo()
    {
        return $this->TemperatureInfo;
    }
    /**
     * Set TemperatureInfo value
     * @param \StructType\VehicleTemperatureInfo $temperatureInfo
     * @return \StructType\VehicleResult_V3
     */
    public function setTemperatureInfo(\StructType\VehicleTemperatureInfo $temperatureInfo = null)
    {
        $this->TemperatureInfo = $temperatureInfo;
        return $this;
    }
    /**
     * Get InfoFields value
     * @return \StructType\VehicleInfoFields|null
     */
    public function getInfoFields()
    {
        return $this->InfoFields;
    }
    /**
     * Set InfoFields value
     * @param \StructType\VehicleInfoFields $infoFields
     * @return \StructType\VehicleResult_V3
     */
    public function setInfoFields(\StructType\VehicleInfoFields $infoFields = null)
    {
        $this->InfoFields = $infoFields;
        return $this;
    }
    /**
     * Get UpdateDates value
     * @return \StructType\VehicleUpdateDates|null
     */
    public function getUpdateDates()
    {
        return $this->UpdateDates;
    }
    /**
     * Set UpdateDates value
     * @param \StructType\VehicleUpdateDates $updateDates
     * @return \StructType\VehicleResult_V3
     */
    public function setUpdateDates(\StructType\VehicleUpdateDates $updateDates = null)
    {
        $this->UpdateDates = $updateDates;
        return $this;
    }
    /**
     * Get VehicleCostInfo value
     * @return \StructType\VehicleCostInfo|null
     */
    public function getVehicleCostInfo()
    {
        return $this->VehicleCostInfo;
    }
    /**
     * Set VehicleCostInfo value
     * @param \StructType\VehicleCostInfo $vehicleCostInfo
     * @return \StructType\VehicleResult_V3
     */
    public function setVehicleCostInfo(\StructType\VehicleCostInfo $vehicleCostInfo = null)
    {
        $this->VehicleCostInfo = $vehicleCostInfo;
        return $this;
    }
    /**
     * Get NextStopInfo value
     * @return \StructType\NextStopResult|null
     */
    public function getNextStopInfo()
    {
        return $this->NextStopInfo;
    }
    /**
     * Set NextStopInfo value
     * @param \StructType\NextStopResult $nextStopInfo
     * @return \StructType\VehicleResult_V3
     */
    public function setNextStopInfo(\StructType\NextStopResult $nextStopInfo = null)
    {
        $this->NextStopInfo = $nextStopInfo;
        return $this;
    }
    /**
     * Get FormattedName value
     * @return string|null
     */
    public function getFormattedName()
    {
        return $this->FormattedName;
    }
    /**
     * Set FormattedName value
     * @param string $formattedName
     * @return \StructType\VehicleResult_V3
     */
    public function setFormattedName($formattedName = null)
    {
        // validation for constraint: string
        if (!is_null($formattedName) && !is_string($formattedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formattedName)), __LINE__);
        }
        $this->FormattedName = $formattedName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleResult_V3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
