<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleProfileResult StructType
 * @subpackage Structs
 */
class VehicleProfileResult extends AbstractStructBase
{
    /**
     * The IsDefaultProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDefaultProfile;
    /**
     * The ProfileType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProfileType;
    /**
     * The ProfileId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProfileId;
    /**
     * The ProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileName;
    /**
     * The ProfileDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileDescription;
    /**
     * Constructor method for VehicleProfileResult
     * @uses VehicleProfileResult::setIsDefaultProfile()
     * @uses VehicleProfileResult::setProfileType()
     * @uses VehicleProfileResult::setProfileId()
     * @uses VehicleProfileResult::setProfileName()
     * @uses VehicleProfileResult::setProfileDescription()
     * @param bool $isDefaultProfile
     * @param string $profileType
     * @param int $profileId
     * @param string $profileName
     * @param string $profileDescription
     */
    public function __construct($isDefaultProfile = null, $profileType = null, $profileId = null, $profileName = null, $profileDescription = null)
    {
        $this
            ->setIsDefaultProfile($isDefaultProfile)
            ->setProfileType($profileType)
            ->setProfileId($profileId)
            ->setProfileName($profileName)
            ->setProfileDescription($profileDescription);
    }
    /**
     * Get IsDefaultProfile value
     * @return bool
     */
    public function getIsDefaultProfile()
    {
        return $this->IsDefaultProfile;
    }
    /**
     * Set IsDefaultProfile value
     * @param bool $isDefaultProfile
     * @return \StructType\VehicleProfileResult
     */
    public function setIsDefaultProfile($isDefaultProfile = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefaultProfile) && !is_bool($isDefaultProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDefaultProfile)), __LINE__);
        }
        $this->IsDefaultProfile = $isDefaultProfile;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @uses \EnumType\EnumVehicleProfileType::valueIsValid()
     * @uses \EnumType\EnumVehicleProfileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $profileType
     * @return \StructType\VehicleProfileResult
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumVehicleProfileType::valueIsValid($profileType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $profileType, implode(', ', \EnumType\EnumVehicleProfileType::getValidValues())), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get ProfileId value
     * @return int
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\VehicleProfileResult
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Get ProfileName value
     * @return string|null
     */
    public function getProfileName()
    {
        return $this->ProfileName;
    }
    /**
     * Set ProfileName value
     * @param string $profileName
     * @return \StructType\VehicleProfileResult
     */
    public function setProfileName($profileName = null)
    {
        // validation for constraint: string
        if (!is_null($profileName) && !is_string($profileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileName)), __LINE__);
        }
        $this->ProfileName = $profileName;
        return $this;
    }
    /**
     * Get ProfileDescription value
     * @return string|null
     */
    public function getProfileDescription()
    {
        return $this->ProfileDescription;
    }
    /**
     * Set ProfileDescription value
     * @param string $profileDescription
     * @return \StructType\VehicleProfileResult
     */
    public function setProfileDescription($profileDescription = null)
    {
        // validation for constraint: string
        if (!is_null($profileDescription) && !is_string($profileDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileDescription)), __LINE__);
        }
        $this->ProfileDescription = $profileDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleProfileResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
