<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleLoadInfo StructType
 * @subpackage Structs
 */
class VehicleLoadInfo extends AbstractStructBase
{
    /**
     * The LoadCapacityWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $LoadCapacityWeight;
    /**
     * The LoadCapacityVolumn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $LoadCapacityVolumn;
    /**
     * The LoadHeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $LoadHeight;
    /**
     * The LoadLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $LoadLength;
    /**
     * The LoadWidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $LoadWidth;
    /**
     * The MaxAllowedMass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaxAllowedMass;
    /**
     * Constructor method for VehicleLoadInfo
     * @uses VehicleLoadInfo::setLoadCapacityWeight()
     * @uses VehicleLoadInfo::setLoadCapacityVolumn()
     * @uses VehicleLoadInfo::setLoadHeight()
     * @uses VehicleLoadInfo::setLoadLength()
     * @uses VehicleLoadInfo::setLoadWidth()
     * @uses VehicleLoadInfo::setMaxAllowedMass()
     * @param int $loadCapacityWeight
     * @param float $loadCapacityVolumn
     * @param float $loadHeight
     * @param float $loadLength
     * @param float $loadWidth
     * @param int $maxAllowedMass
     */
    public function __construct($loadCapacityWeight = null, $loadCapacityVolumn = null, $loadHeight = null, $loadLength = null, $loadWidth = null, $maxAllowedMass = null)
    {
        $this
            ->setLoadCapacityWeight($loadCapacityWeight)
            ->setLoadCapacityVolumn($loadCapacityVolumn)
            ->setLoadHeight($loadHeight)
            ->setLoadLength($loadLength)
            ->setLoadWidth($loadWidth)
            ->setMaxAllowedMass($maxAllowedMass);
    }
    /**
     * Get LoadCapacityWeight value
     * @return int
     */
    public function getLoadCapacityWeight()
    {
        return $this->LoadCapacityWeight;
    }
    /**
     * Set LoadCapacityWeight value
     * @param int $loadCapacityWeight
     * @return \StructType\VehicleLoadInfo
     */
    public function setLoadCapacityWeight($loadCapacityWeight = null)
    {
        // validation for constraint: int
        if (!is_null($loadCapacityWeight) && !is_numeric($loadCapacityWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($loadCapacityWeight)), __LINE__);
        }
        $this->LoadCapacityWeight = $loadCapacityWeight;
        return $this;
    }
    /**
     * Get LoadCapacityVolumn value
     * @return float
     */
    public function getLoadCapacityVolumn()
    {
        return $this->LoadCapacityVolumn;
    }
    /**
     * Set LoadCapacityVolumn value
     * @param float $loadCapacityVolumn
     * @return \StructType\VehicleLoadInfo
     */
    public function setLoadCapacityVolumn($loadCapacityVolumn = null)
    {
        $this->LoadCapacityVolumn = $loadCapacityVolumn;
        return $this;
    }
    /**
     * Get LoadHeight value
     * @return float
     */
    public function getLoadHeight()
    {
        return $this->LoadHeight;
    }
    /**
     * Set LoadHeight value
     * @param float $loadHeight
     * @return \StructType\VehicleLoadInfo
     */
    public function setLoadHeight($loadHeight = null)
    {
        $this->LoadHeight = $loadHeight;
        return $this;
    }
    /**
     * Get LoadLength value
     * @return float
     */
    public function getLoadLength()
    {
        return $this->LoadLength;
    }
    /**
     * Set LoadLength value
     * @param float $loadLength
     * @return \StructType\VehicleLoadInfo
     */
    public function setLoadLength($loadLength = null)
    {
        $this->LoadLength = $loadLength;
        return $this;
    }
    /**
     * Get LoadWidth value
     * @return float
     */
    public function getLoadWidth()
    {
        return $this->LoadWidth;
    }
    /**
     * Set LoadWidth value
     * @param float $loadWidth
     * @return \StructType\VehicleLoadInfo
     */
    public function setLoadWidth($loadWidth = null)
    {
        $this->LoadWidth = $loadWidth;
        return $this;
    }
    /**
     * Get MaxAllowedMass value
     * @return int
     */
    public function getMaxAllowedMass()
    {
        return $this->MaxAllowedMass;
    }
    /**
     * Set MaxAllowedMass value
     * @param int $maxAllowedMass
     * @return \StructType\VehicleLoadInfo
     */
    public function setMaxAllowedMass($maxAllowedMass = null)
    {
        // validation for constraint: int
        if (!is_null($maxAllowedMass) && !is_numeric($maxAllowedMass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxAllowedMass)), __LINE__);
        }
        $this->MaxAllowedMass = $maxAllowedMass;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleLoadInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
