<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleInsert StructType
 * @subpackage Structs
 */
class VehicleInsert extends Vehicle_V2
{
    /**
     * The BelgianManureBankCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BelgianManureBankCode;
    /**
     * The Purchase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Purchase;
    /**
     * The Rented
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Rented;
    /**
     * The RentStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RentStatus;
    /**
     * The TypeOfObc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TypeOfObc;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The Site
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierSite
     */
    public $Site;
    /**
     * The VehicleProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleProfile
     */
    public $VehicleProfile;
    /**
     * The TracerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TracerID;
    /**
     * The AutoFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoFilter;
    /**
     * The GsmNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GsmNumber;
    /**
     * The HomebaseNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HomebaseNumber;
    /**
     * The CompanyCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyCard;
    /**
     * The ExtraInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtraInformation;
    /**
     * Constructor method for VehicleInsert
     * @uses VehicleInsert::setBelgianManureBankCode()
     * @uses VehicleInsert::setPurchase()
     * @uses VehicleInsert::setRented()
     * @uses VehicleInsert::setRentStatus()
     * @uses VehicleInsert::setTypeOfObc()
     * @uses VehicleInsert::setCategory()
     * @uses VehicleInsert::setSite()
     * @uses VehicleInsert::setVehicleProfile()
     * @uses VehicleInsert::setTracerID()
     * @uses VehicleInsert::setAutoFilter()
     * @uses VehicleInsert::setGsmNumber()
     * @uses VehicleInsert::setHomebaseNumber()
     * @uses VehicleInsert::setCompanyCard()
     * @uses VehicleInsert::setExtraInformation()
     * @param int $belgianManureBankCode
     * @param string $purchase
     * @param bool $rented
     * @param bool $rentStatus
     * @param string $typeOfObc
     * @param string $category
     * @param \StructType\IdentifierSite $site
     * @param \StructType\VehicleProfile $vehicleProfile
     * @param string $tracerID
     * @param string $autoFilter
     * @param string $gsmNumber
     * @param string $homebaseNumber
     * @param string $companyCard
     * @param string $extraInformation
     */
    public function __construct($belgianManureBankCode = null, $purchase = null, $rented = null, $rentStatus = null, $typeOfObc = null, $category = null, \StructType\IdentifierSite $site = null, \StructType\VehicleProfile $vehicleProfile = null, $tracerID = null, $autoFilter = null, $gsmNumber = null, $homebaseNumber = null, $companyCard = null, $extraInformation = null)
    {
        $this
            ->setBelgianManureBankCode($belgianManureBankCode)
            ->setPurchase($purchase)
            ->setRented($rented)
            ->setRentStatus($rentStatus)
            ->setTypeOfObc($typeOfObc)
            ->setCategory($category)
            ->setSite($site)
            ->setVehicleProfile($vehicleProfile)
            ->setTracerID($tracerID)
            ->setAutoFilter($autoFilter)
            ->setGsmNumber($gsmNumber)
            ->setHomebaseNumber($homebaseNumber)
            ->setCompanyCard($companyCard)
            ->setExtraInformation($extraInformation);
    }
    /**
     * Get BelgianManureBankCode value
     * @return int
     */
    public function getBelgianManureBankCode()
    {
        return $this->BelgianManureBankCode;
    }
    /**
     * Set BelgianManureBankCode value
     * @param int $belgianManureBankCode
     * @return \StructType\VehicleInsert
     */
    public function setBelgianManureBankCode($belgianManureBankCode = null)
    {
        // validation for constraint: int
        if (!is_null($belgianManureBankCode) && !is_numeric($belgianManureBankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($belgianManureBankCode)), __LINE__);
        }
        $this->BelgianManureBankCode = $belgianManureBankCode;
        return $this;
    }
    /**
     * Get Purchase value
     * @return string
     */
    public function getPurchase()
    {
        return $this->Purchase;
    }
    /**
     * Set Purchase value
     * @param string $purchase
     * @return \StructType\VehicleInsert
     */
    public function setPurchase($purchase = null)
    {
        // validation for constraint: string
        if (!is_null($purchase) && !is_string($purchase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purchase)), __LINE__);
        }
        $this->Purchase = $purchase;
        return $this;
    }
    /**
     * Get Rented value
     * @return bool
     */
    public function getRented()
    {
        return $this->Rented;
    }
    /**
     * Set Rented value
     * @param bool $rented
     * @return \StructType\VehicleInsert
     */
    public function setRented($rented = null)
    {
        // validation for constraint: boolean
        if (!is_null($rented) && !is_bool($rented)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($rented)), __LINE__);
        }
        $this->Rented = $rented;
        return $this;
    }
    /**
     * Get RentStatus value
     * @return bool
     */
    public function getRentStatus()
    {
        return $this->RentStatus;
    }
    /**
     * Set RentStatus value
     * @param bool $rentStatus
     * @return \StructType\VehicleInsert
     */
    public function setRentStatus($rentStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($rentStatus) && !is_bool($rentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($rentStatus)), __LINE__);
        }
        $this->RentStatus = $rentStatus;
        return $this;
    }
    /**
     * Get TypeOfObc value
     * @return string
     */
    public function getTypeOfObc()
    {
        return $this->TypeOfObc;
    }
    /**
     * Set TypeOfObc value
     * @uses \EnumType\ObcType::valueIsValid()
     * @uses \EnumType\ObcType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfObc
     * @return \StructType\VehicleInsert
     */
    public function setTypeOfObc($typeOfObc = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ObcType::valueIsValid($typeOfObc)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $typeOfObc, implode(', ', \EnumType\ObcType::getValidValues())), __LINE__);
        }
        $this->TypeOfObc = $typeOfObc;
        return $this;
    }
    /**
     * Get Category value
     * @return string
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @uses \EnumType\VehicleCategory::valueIsValid()
     * @uses \EnumType\VehicleCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return \StructType\VehicleInsert
     */
    public function setCategory($category = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleCategory::valueIsValid($category)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $category, implode(', ', \EnumType\VehicleCategory::getValidValues())), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Site value
     * @return \StructType\IdentifierSite|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\IdentifierSite $site
     * @return \StructType\VehicleInsert
     */
    public function setSite(\StructType\IdentifierSite $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get VehicleProfile value
     * @return \StructType\VehicleProfile|null
     */
    public function getVehicleProfile()
    {
        return $this->VehicleProfile;
    }
    /**
     * Set VehicleProfile value
     * @param \StructType\VehicleProfile $vehicleProfile
     * @return \StructType\VehicleInsert
     */
    public function setVehicleProfile(\StructType\VehicleProfile $vehicleProfile = null)
    {
        $this->VehicleProfile = $vehicleProfile;
        return $this;
    }
    /**
     * Get TracerID value
     * @return string|null
     */
    public function getTracerID()
    {
        return $this->TracerID;
    }
    /**
     * Set TracerID value
     * @param string $tracerID
     * @return \StructType\VehicleInsert
     */
    public function setTracerID($tracerID = null)
    {
        // validation for constraint: string
        if (!is_null($tracerID) && !is_string($tracerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tracerID)), __LINE__);
        }
        $this->TracerID = $tracerID;
        return $this;
    }
    /**
     * Get AutoFilter value
     * @return string|null
     */
    public function getAutoFilter()
    {
        return $this->AutoFilter;
    }
    /**
     * Set AutoFilter value
     * @param string $autoFilter
     * @return \StructType\VehicleInsert
     */
    public function setAutoFilter($autoFilter = null)
    {
        // validation for constraint: string
        if (!is_null($autoFilter) && !is_string($autoFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoFilter)), __LINE__);
        }
        $this->AutoFilter = $autoFilter;
        return $this;
    }
    /**
     * Get GsmNumber value
     * @return string|null
     */
    public function getGsmNumber()
    {
        return $this->GsmNumber;
    }
    /**
     * Set GsmNumber value
     * @param string $gsmNumber
     * @return \StructType\VehicleInsert
     */
    public function setGsmNumber($gsmNumber = null)
    {
        // validation for constraint: string
        if (!is_null($gsmNumber) && !is_string($gsmNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gsmNumber)), __LINE__);
        }
        $this->GsmNumber = $gsmNumber;
        return $this;
    }
    /**
     * Get HomebaseNumber value
     * @return string|null
     */
    public function getHomebaseNumber()
    {
        return $this->HomebaseNumber;
    }
    /**
     * Set HomebaseNumber value
     * @param string $homebaseNumber
     * @return \StructType\VehicleInsert
     */
    public function setHomebaseNumber($homebaseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($homebaseNumber) && !is_string($homebaseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homebaseNumber)), __LINE__);
        }
        $this->HomebaseNumber = $homebaseNumber;
        return $this;
    }
    /**
     * Get CompanyCard value
     * @return string|null
     */
    public function getCompanyCard()
    {
        return $this->CompanyCard;
    }
    /**
     * Set CompanyCard value
     * @param string $companyCard
     * @return \StructType\VehicleInsert
     */
    public function setCompanyCard($companyCard = null)
    {
        // validation for constraint: string
        if (!is_null($companyCard) && !is_string($companyCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyCard)), __LINE__);
        }
        $this->CompanyCard = $companyCard;
        return $this;
    }
    /**
     * Get ExtraInformation value
     * @return string|null
     */
    public function getExtraInformation()
    {
        return $this->ExtraInformation;
    }
    /**
     * Set ExtraInformation value
     * @param string $extraInformation
     * @return \StructType\VehicleInsert
     */
    public function setExtraInformation($extraInformation = null)
    {
        // validation for constraint: string
        if (!is_null($extraInformation) && !is_string($extraInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extraInformation)), __LINE__);
        }
        $this->ExtraInformation = $extraInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleInsert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
