<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleIdentifier StructType
 * @subpackage Structs
 */
class VehicleIdentifier extends AbstractStructBase
{
    /**
     * The TransicsVehicleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsVehicleID;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The LicensePlate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * Constructor method for VehicleIdentifier
     * @uses VehicleIdentifier::setTransicsVehicleID()
     * @uses VehicleIdentifier::setID()
     * @uses VehicleIdentifier::setLicensePlate()
     * @uses VehicleIdentifier::setCode()
     * @param int $transicsVehicleID
     * @param string $iD
     * @param string $licensePlate
     * @param string $code
     */
    public function __construct($transicsVehicleID = null, $iD = null, $licensePlate = null, $code = null)
    {
        $this
            ->setTransicsVehicleID($transicsVehicleID)
            ->setID($iD)
            ->setLicensePlate($licensePlate)
            ->setCode($code);
    }
    /**
     * Get TransicsVehicleID value
     * @return int
     */
    public function getTransicsVehicleID()
    {
        return $this->TransicsVehicleID;
    }
    /**
     * Set TransicsVehicleID value
     * @param int $transicsVehicleID
     * @return \StructType\VehicleIdentifier
     */
    public function setTransicsVehicleID($transicsVehicleID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsVehicleID) && !is_numeric($transicsVehicleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsVehicleID)), __LINE__);
        }
        $this->TransicsVehicleID = $transicsVehicleID;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\VehicleIdentifier
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \StructType\VehicleIdentifier
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\VehicleIdentifier
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
