<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleCompanyCard StructType
 * @subpackage Structs
 */
class VehicleCompanyCard extends AbstractStructBase
{
    /**
     * The CardId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CardId;
    /**
     * The CardName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardName;
    /**
     * Constructor method for VehicleCompanyCard
     * @uses VehicleCompanyCard::setCardId()
     * @uses VehicleCompanyCard::setCardName()
     * @param int $cardId
     * @param string $cardName
     */
    public function __construct($cardId = null, $cardName = null)
    {
        $this
            ->setCardId($cardId)
            ->setCardName($cardName);
    }
    /**
     * Get CardId value
     * @return int
     */
    public function getCardId()
    {
        return $this->CardId;
    }
    /**
     * Set CardId value
     * @param int $cardId
     * @return \StructType\VehicleCompanyCard
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: int
        if (!is_null($cardId) && !is_numeric($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cardId)), __LINE__);
        }
        $this->CardId = $cardId;
        return $this;
    }
    /**
     * Get CardName value
     * @return string|null
     */
    public function getCardName()
    {
        return $this->CardName;
    }
    /**
     * Set CardName value
     * @param string $cardName
     * @return \StructType\VehicleCompanyCard
     */
    public function setCardName($cardName = null)
    {
        // validation for constraint: string
        if (!is_null($cardName) && !is_string($cardName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardName)), __LINE__);
        }
        $this->CardName = $cardName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleCompanyCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
