<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleActivityInfoItem_V2 StructType
 * @subpackage Structs
 */
class VehicleActivityInfoItem_V2 extends VehicleActivityInfoItem
{
    /**
     * The DateTimeSent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateTimeSent;
    /**
     * The Kilometers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Kilometers;
    /**
     * The ModificationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The CommunicationChannel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommunicationChannel;
    /**
     * Constructor method for VehicleActivityInfoItem_V2
     * @uses VehicleActivityInfoItem_V2::setDateTimeSent()
     * @uses VehicleActivityInfoItem_V2::setKilometers()
     * @uses VehicleActivityInfoItem_V2::setModificationDate()
     * @uses VehicleActivityInfoItem_V2::setCommunicationChannel()
     * @param string $dateTimeSent
     * @param int $kilometers
     * @param string $modificationDate
     * @param string $communicationChannel
     */
    public function __construct($dateTimeSent = null, $kilometers = null, $modificationDate = null, $communicationChannel = null)
    {
        $this
            ->setDateTimeSent($dateTimeSent)
            ->setKilometers($kilometers)
            ->setModificationDate($modificationDate)
            ->setCommunicationChannel($communicationChannel);
    }
    /**
     * Get DateTimeSent value
     * @return string
     */
    public function getDateTimeSent()
    {
        return $this->DateTimeSent;
    }
    /**
     * Set DateTimeSent value
     * @param string $dateTimeSent
     * @return \StructType\VehicleActivityInfoItem_V2
     */
    public function setDateTimeSent($dateTimeSent = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeSent) && !is_string($dateTimeSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTimeSent)), __LINE__);
        }
        $this->DateTimeSent = $dateTimeSent;
        return $this;
    }
    /**
     * Get Kilometers value
     * @return int
     */
    public function getKilometers()
    {
        return $this->Kilometers;
    }
    /**
     * Set Kilometers value
     * @param int $kilometers
     * @return \StructType\VehicleActivityInfoItem_V2
     */
    public function setKilometers($kilometers = null)
    {
        // validation for constraint: int
        if (!is_null($kilometers) && !is_numeric($kilometers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kilometers)), __LINE__);
        }
        $this->Kilometers = $kilometers;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\VehicleActivityInfoItem_V2
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get CommunicationChannel value
     * @return string|null
     */
    public function getCommunicationChannel()
    {
        return $this->CommunicationChannel;
    }
    /**
     * Set CommunicationChannel value
     * @param string $communicationChannel
     * @return \StructType\VehicleActivityInfoItem_V2
     */
    public function setCommunicationChannel($communicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($communicationChannel) && !is_string($communicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communicationChannel)), __LINE__);
        }
        $this->CommunicationChannel = $communicationChannel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleActivityInfoItem_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
