<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TruckStrategy StructType
 * @subpackage Structs
 */
class TruckStrategy extends IdentifierVehicleStrategy
{
    /**
     * The IdentifierVehicleType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentifierVehicleType;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for TruckStrategy
     * @uses TruckStrategy::setIdentifierVehicleType()
     * @uses TruckStrategy::setId()
     * @param string $identifierVehicleType
     * @param string $id
     */
    public function __construct($identifierVehicleType = null, $id = null)
    {
        $this
            ->setIdentifierVehicleType($identifierVehicleType)
            ->setId($id);
    }
    /**
     * Get IdentifierVehicleType value
     * @return string
     */
    public function getIdentifierVehicleType()
    {
        return $this->IdentifierVehicleType;
    }
    /**
     * Set IdentifierVehicleType value
     * @uses \EnumType\EnumIdentifierVehicleType::valueIsValid()
     * @uses \EnumType\EnumIdentifierVehicleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identifierVehicleType
     * @return \StructType\TruckStrategy
     */
    public function setIdentifierVehicleType($identifierVehicleType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumIdentifierVehicleType::valueIsValid($identifierVehicleType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $identifierVehicleType, implode(', ', \EnumType\EnumIdentifierVehicleType::getValidValues())), __LINE__);
        }
        $this->IdentifierVehicleType = $identifierVehicleType;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\TruckStrategy
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TruckStrategy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
