<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripReportSummaryResult StructType
 * @subpackage Structs
 */
class TripReportSummaryResult extends AbstractStructBase
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The TotalDistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalDistance;
    /**
     * The TotalConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalConsumption;
    /**
     * The AverageConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AverageConsumption;
    /**
     * The TotalRefueled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalRefueled;
    /**
     * The TotalDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalDuration;
    /**
     * The TripID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripID;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTripReportTrailerSummary
     */
    public $Trailers;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Activities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTripReportActivitySummary
     */
    public $Activities;
    /**
     * The ServiceTimesTacho
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTripReportTachoSummary
     */
    public $ServiceTimesTacho;
    /**
     * Constructor method for TripReportSummaryResult
     * @uses TripReportSummaryResult::setStartDate()
     * @uses TripReportSummaryResult::setEndDate()
     * @uses TripReportSummaryResult::setTotalDistance()
     * @uses TripReportSummaryResult::setTotalConsumption()
     * @uses TripReportSummaryResult::setAverageConsumption()
     * @uses TripReportSummaryResult::setTotalRefueled()
     * @uses TripReportSummaryResult::setTotalDuration()
     * @uses TripReportSummaryResult::setTripID()
     * @uses TripReportSummaryResult::setVehicle()
     * @uses TripReportSummaryResult::setTrailers()
     * @uses TripReportSummaryResult::setDriver()
     * @uses TripReportSummaryResult::setActivities()
     * @uses TripReportSummaryResult::setServiceTimesTacho()
     * @param string $startDate
     * @param string $endDate
     * @param float $totalDistance
     * @param float $totalConsumption
     * @param float $averageConsumption
     * @param float $totalRefueled
     * @param float $totalDuration
     * @param string $tripID
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \ArrayType\ArrayOfTripReportTrailerSummary $trailers
     * @param \StructType\IdentifierPerson $driver
     * @param \ArrayType\ArrayOfTripReportActivitySummary $activities
     * @param \ArrayType\ArrayOfTripReportTachoSummary $serviceTimesTacho
     */
    public function __construct($startDate = null, $endDate = null, $totalDistance = null, $totalConsumption = null, $averageConsumption = null, $totalRefueled = null, $totalDuration = null, $tripID = null, \StructType\IdentifierVehicleResult $vehicle = null, \ArrayType\ArrayOfTripReportTrailerSummary $trailers = null, \StructType\IdentifierPerson $driver = null, \ArrayType\ArrayOfTripReportActivitySummary $activities = null, \ArrayType\ArrayOfTripReportTachoSummary $serviceTimesTacho = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setTotalDistance($totalDistance)
            ->setTotalConsumption($totalConsumption)
            ->setAverageConsumption($averageConsumption)
            ->setTotalRefueled($totalRefueled)
            ->setTotalDuration($totalDuration)
            ->setTripID($tripID)
            ->setVehicle($vehicle)
            ->setTrailers($trailers)
            ->setDriver($driver)
            ->setActivities($activities)
            ->setServiceTimesTacho($serviceTimesTacho);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\TripReportSummaryResult
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\TripReportSummaryResult
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get TotalDistance value
     * @return float
     */
    public function getTotalDistance()
    {
        return $this->TotalDistance;
    }
    /**
     * Set TotalDistance value
     * @param float $totalDistance
     * @return \StructType\TripReportSummaryResult
     */
    public function setTotalDistance($totalDistance = null)
    {
        $this->TotalDistance = $totalDistance;
        return $this;
    }
    /**
     * Get TotalConsumption value
     * @return float
     */
    public function getTotalConsumption()
    {
        return $this->TotalConsumption;
    }
    /**
     * Set TotalConsumption value
     * @param float $totalConsumption
     * @return \StructType\TripReportSummaryResult
     */
    public function setTotalConsumption($totalConsumption = null)
    {
        $this->TotalConsumption = $totalConsumption;
        return $this;
    }
    /**
     * Get AverageConsumption value
     * @return float
     */
    public function getAverageConsumption()
    {
        return $this->AverageConsumption;
    }
    /**
     * Set AverageConsumption value
     * @param float $averageConsumption
     * @return \StructType\TripReportSummaryResult
     */
    public function setAverageConsumption($averageConsumption = null)
    {
        $this->AverageConsumption = $averageConsumption;
        return $this;
    }
    /**
     * Get TotalRefueled value
     * @return float
     */
    public function getTotalRefueled()
    {
        return $this->TotalRefueled;
    }
    /**
     * Set TotalRefueled value
     * @param float $totalRefueled
     * @return \StructType\TripReportSummaryResult
     */
    public function setTotalRefueled($totalRefueled = null)
    {
        $this->TotalRefueled = $totalRefueled;
        return $this;
    }
    /**
     * Get TotalDuration value
     * @return float
     */
    public function getTotalDuration()
    {
        return $this->TotalDuration;
    }
    /**
     * Set TotalDuration value
     * @param float $totalDuration
     * @return \StructType\TripReportSummaryResult
     */
    public function setTotalDuration($totalDuration = null)
    {
        $this->TotalDuration = $totalDuration;
        return $this;
    }
    /**
     * Get TripID value
     * @return string|null
     */
    public function getTripID()
    {
        return $this->TripID;
    }
    /**
     * Set TripID value
     * @param string $tripID
     * @return \StructType\TripReportSummaryResult
     */
    public function setTripID($tripID = null)
    {
        // validation for constraint: string
        if (!is_null($tripID) && !is_string($tripID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tripID)), __LINE__);
        }
        $this->TripID = $tripID;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\TripReportSummaryResult
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailers value
     * @return \ArrayType\ArrayOfTripReportTrailerSummary|null
     */
    public function getTrailers()
    {
        return $this->Trailers;
    }
    /**
     * Set Trailers value
     * @param \ArrayType\ArrayOfTripReportTrailerSummary $trailers
     * @return \StructType\TripReportSummaryResult
     */
    public function setTrailers(\ArrayType\ArrayOfTripReportTrailerSummary $trailers = null)
    {
        $this->Trailers = $trailers;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\TripReportSummaryResult
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Activities value
     * @return \ArrayType\ArrayOfTripReportActivitySummary|null
     */
    public function getActivities()
    {
        return $this->Activities;
    }
    /**
     * Set Activities value
     * @param \ArrayType\ArrayOfTripReportActivitySummary $activities
     * @return \StructType\TripReportSummaryResult
     */
    public function setActivities(\ArrayType\ArrayOfTripReportActivitySummary $activities = null)
    {
        $this->Activities = $activities;
        return $this;
    }
    /**
     * Get ServiceTimesTacho value
     * @return \ArrayType\ArrayOfTripReportTachoSummary|null
     */
    public function getServiceTimesTacho()
    {
        return $this->ServiceTimesTacho;
    }
    /**
     * Set ServiceTimesTacho value
     * @param \ArrayType\ArrayOfTripReportTachoSummary $serviceTimesTacho
     * @return \StructType\TripReportSummaryResult
     */
    public function setServiceTimesTacho(\ArrayType\ArrayOfTripReportTachoSummary $serviceTimesTacho = null)
    {
        $this->ServiceTimesTacho = $serviceTimesTacho;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TripReportSummaryResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
