<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripReportActivitySummary StructType
 * @subpackage Structs
 */
class TripReportActivitySummary extends Activity
{
    /**
     * The ExecutionCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExecutionCount;
    /**
     * The TotalDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDuration;
    /**
     * The TotalDistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDistance;
    /**
     * The TotalConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalConsumption;
    /**
     * Constructor method for TripReportActivitySummary
     * @uses TripReportActivitySummary::setExecutionCount()
     * @uses TripReportActivitySummary::setTotalDuration()
     * @uses TripReportActivitySummary::setTotalDistance()
     * @uses TripReportActivitySummary::setTotalConsumption()
     * @param int $executionCount
     * @param float $totalDuration
     * @param float $totalDistance
     * @param float $totalConsumption
     */
    public function __construct($executionCount = null, $totalDuration = null, $totalDistance = null, $totalConsumption = null)
    {
        $this
            ->setExecutionCount($executionCount)
            ->setTotalDuration($totalDuration)
            ->setTotalDistance($totalDistance)
            ->setTotalConsumption($totalConsumption);
    }
    /**
     * Get ExecutionCount value
     * @return int
     */
    public function getExecutionCount()
    {
        return $this->ExecutionCount;
    }
    /**
     * Set ExecutionCount value
     * @param int $executionCount
     * @return \StructType\TripReportActivitySummary
     */
    public function setExecutionCount($executionCount = null)
    {
        // validation for constraint: int
        if (!is_null($executionCount) && !is_numeric($executionCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($executionCount)), __LINE__);
        }
        $this->ExecutionCount = $executionCount;
        return $this;
    }
    /**
     * Get TotalDuration value
     * @return float
     */
    public function getTotalDuration()
    {
        return $this->TotalDuration;
    }
    /**
     * Set TotalDuration value
     * @param float $totalDuration
     * @return \StructType\TripReportActivitySummary
     */
    public function setTotalDuration($totalDuration = null)
    {
        $this->TotalDuration = $totalDuration;
        return $this;
    }
    /**
     * Get TotalDistance value
     * @return float
     */
    public function getTotalDistance()
    {
        return $this->TotalDistance;
    }
    /**
     * Set TotalDistance value
     * @param float $totalDistance
     * @return \StructType\TripReportActivitySummary
     */
    public function setTotalDistance($totalDistance = null)
    {
        $this->TotalDistance = $totalDistance;
        return $this;
    }
    /**
     * Get TotalConsumption value
     * @return float
     */
    public function getTotalConsumption()
    {
        return $this->TotalConsumption;
    }
    /**
     * Set TotalConsumption value
     * @param float $totalConsumption
     * @return \StructType\TripReportActivitySummary
     */
    public function setTotalConsumption($totalConsumption = null)
    {
        $this->TotalConsumption = $totalConsumption;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TripReportActivitySummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
