<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripItemResult_V6 StructType
 * @subpackage Structs
 */
class TripItemResult_V6 extends Trip
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ModificationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The TransferStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TransferStatus;
    /**
     * The ExternalSynchStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExternalSynchStatus;
    /**
     * The CancelStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CancelStatus;
    /**
     * The TransicsTripID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsTripID;
    /**
     * The TripStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TripStatus;
    /**
     * The SalesPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SalesPrice;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Author
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Author;
    /**
     * The Places
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPlaceIdentifier_V3
     */
    public $Places;
    /**
     * The TachoActivities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTachoActivity
     */
    public $TachoActivities;
    /**
     * The Registrations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRegistration_v2
     */
    public $Registrations;
    /**
     * The CoDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $CoDriver;
    /**
     * Constructor method for TripItemResult_V6
     * @uses TripItemResult_V6::setStartDate()
     * @uses TripItemResult_V6::setEndDate()
     * @uses TripItemResult_V6::setModificationDate()
     * @uses TripItemResult_V6::setStatus()
     * @uses TripItemResult_V6::setTransferStatus()
     * @uses TripItemResult_V6::setExternalSynchStatus()
     * @uses TripItemResult_V6::setCancelStatus()
     * @uses TripItemResult_V6::setTransicsTripID()
     * @uses TripItemResult_V6::setTripStatus()
     * @uses TripItemResult_V6::setSalesPrice()
     * @uses TripItemResult_V6::setDriver()
     * @uses TripItemResult_V6::setVehicle()
     * @uses TripItemResult_V6::setAuthor()
     * @uses TripItemResult_V6::setPlaces()
     * @uses TripItemResult_V6::setTachoActivities()
     * @uses TripItemResult_V6::setRegistrations()
     * @uses TripItemResult_V6::setCoDriver()
     * @param string $startDate
     * @param string $endDate
     * @param string $modificationDate
     * @param string $status
     * @param string $transferStatus
     * @param string $externalSynchStatus
     * @param string $cancelStatus
     * @param int $transicsTripID
     * @param string $tripStatus
     * @param float $salesPrice
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param string $author
     * @param \ArrayType\ArrayOfPlaceIdentifier_V3 $places
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @param \ArrayType\ArrayOfRegistration_v2 $registrations
     * @param \StructType\IdentifierPerson_V2 $coDriver
     */
    public function __construct($startDate = null, $endDate = null, $modificationDate = null, $status = null, $transferStatus = null, $externalSynchStatus = null, $cancelStatus = null, $transicsTripID = null, $tripStatus = null, $salesPrice = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, $author = null, \ArrayType\ArrayOfPlaceIdentifier_V3 $places = null, \ArrayType\ArrayOfTachoActivity $tachoActivities = null, \ArrayType\ArrayOfRegistration_v2 $registrations = null, \StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setModificationDate($modificationDate)
            ->setStatus($status)
            ->setTransferStatus($transferStatus)
            ->setExternalSynchStatus($externalSynchStatus)
            ->setCancelStatus($cancelStatus)
            ->setTransicsTripID($transicsTripID)
            ->setTripStatus($tripStatus)
            ->setSalesPrice($salesPrice)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setAuthor($author)
            ->setPlaces($places)
            ->setTachoActivities($tachoActivities)
            ->setRegistrations($registrations)
            ->setCoDriver($coDriver);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\TripItemResult_V6
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\TripItemResult_V6
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\TripItemResult_V6
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumPlanningStatus::valueIsValid()
     * @uses \EnumType\EnumPlanningStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\TripItemResult_V6
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\EnumPlanningStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TransferStatus value
     * @return string
     */
    public function getTransferStatus()
    {
        return $this->TransferStatus;
    }
    /**
     * Set TransferStatus value
     * @uses \EnumType\EnumTransferStatus::valueIsValid()
     * @uses \EnumType\EnumTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferStatus
     * @return \StructType\TripItemResult_V6
     */
    public function setTransferStatus($transferStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTransferStatus::valueIsValid($transferStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transferStatus, implode(', ', \EnumType\EnumTransferStatus::getValidValues())), __LINE__);
        }
        $this->TransferStatus = $transferStatus;
        return $this;
    }
    /**
     * Get ExternalSynchStatus value
     * @return string
     */
    public function getExternalSynchStatus()
    {
        return $this->ExternalSynchStatus;
    }
    /**
     * Set ExternalSynchStatus value
     * @uses \EnumType\EnumSynchronisationStatus::valueIsValid()
     * @uses \EnumType\EnumSynchronisationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $externalSynchStatus
     * @return \StructType\TripItemResult_V6
     */
    public function setExternalSynchStatus($externalSynchStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSynchronisationStatus::valueIsValid($externalSynchStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $externalSynchStatus, implode(', ', \EnumType\EnumSynchronisationStatus::getValidValues())), __LINE__);
        }
        $this->ExternalSynchStatus = $externalSynchStatus;
        return $this;
    }
    /**
     * Get CancelStatus value
     * @return string
     */
    public function getCancelStatus()
    {
        return $this->CancelStatus;
    }
    /**
     * Set CancelStatus value
     * @uses \EnumType\EnumCancelStatus::valueIsValid()
     * @uses \EnumType\EnumCancelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelStatus
     * @return \StructType\TripItemResult_V6
     */
    public function setCancelStatus($cancelStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCancelStatus::valueIsValid($cancelStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cancelStatus, implode(', ', \EnumType\EnumCancelStatus::getValidValues())), __LINE__);
        }
        $this->CancelStatus = $cancelStatus;
        return $this;
    }
    /**
     * Get TransicsTripID value
     * @return int
     */
    public function getTransicsTripID()
    {
        return $this->TransicsTripID;
    }
    /**
     * Set TransicsTripID value
     * @param int $transicsTripID
     * @return \StructType\TripItemResult_V6
     */
    public function setTransicsTripID($transicsTripID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsTripID) && !is_numeric($transicsTripID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsTripID)), __LINE__);
        }
        $this->TransicsTripID = $transicsTripID;
        return $this;
    }
    /**
     * Get TripStatus value
     * @return string
     */
    public function getTripStatus()
    {
        return $this->TripStatus;
    }
    /**
     * Set TripStatus value
     * @uses \EnumType\EnumTripStatus::valueIsValid()
     * @uses \EnumType\EnumTripStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tripStatus
     * @return \StructType\TripItemResult_V6
     */
    public function setTripStatus($tripStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTripStatus::valueIsValid($tripStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tripStatus, implode(', ', \EnumType\EnumTripStatus::getValidValues())), __LINE__);
        }
        $this->TripStatus = $tripStatus;
        return $this;
    }
    /**
     * Get SalesPrice value
     * @return float
     */
    public function getSalesPrice()
    {
        return $this->SalesPrice;
    }
    /**
     * Set SalesPrice value
     * @param float $salesPrice
     * @return \StructType\TripItemResult_V6
     */
    public function setSalesPrice($salesPrice = null)
    {
        $this->SalesPrice = $salesPrice;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\TripItemResult_V6
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\TripItemResult_V6
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\TripItemResult_V6
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get Places value
     * @return \ArrayType\ArrayOfPlaceIdentifier_V3|null
     */
    public function getPlaces()
    {
        return $this->Places;
    }
    /**
     * Set Places value
     * @param \ArrayType\ArrayOfPlaceIdentifier_V3 $places
     * @return \StructType\TripItemResult_V6
     */
    public function setPlaces(\ArrayType\ArrayOfPlaceIdentifier_V3 $places = null)
    {
        $this->Places = $places;
        return $this;
    }
    /**
     * Get TachoActivities value
     * @return \ArrayType\ArrayOfTachoActivity|null
     */
    public function getTachoActivities()
    {
        return $this->TachoActivities;
    }
    /**
     * Set TachoActivities value
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @return \StructType\TripItemResult_V6
     */
    public function setTachoActivities(\ArrayType\ArrayOfTachoActivity $tachoActivities = null)
    {
        $this->TachoActivities = $tachoActivities;
        return $this;
    }
    /**
     * Get Registrations value
     * @return \ArrayType\ArrayOfRegistration_v2|null
     */
    public function getRegistrations()
    {
        return $this->Registrations;
    }
    /**
     * Set Registrations value
     * @param \ArrayType\ArrayOfRegistration_v2 $registrations
     * @return \StructType\TripItemResult_V6
     */
    public function setRegistrations(\ArrayType\ArrayOfRegistration_v2 $registrations = null)
    {
        $this->Registrations = $registrations;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @return \StructType\TripItemResult_V6
     */
    public function setCoDriver(\StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TripItemResult_V6
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
