<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripItemResult_V5 StructType
 * @subpackage Structs
 */
class TripItemResult_V5 extends TripItemResult_V4
{
    /**
     * The TripStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TripStatus;
    /**
     * Constructor method for TripItemResult_V5
     * @uses TripItemResult_V5::setTripStatus()
     * @param string $tripStatus
     */
    public function __construct($tripStatus = null)
    {
        $this
            ->setTripStatus($tripStatus);
    }
    /**
     * Get TripStatus value
     * @return string
     */
    public function getTripStatus()
    {
        return $this->TripStatus;
    }
    /**
     * Set TripStatus value
     * @uses \EnumType\EnumTripStatus::valueIsValid()
     * @uses \EnumType\EnumTripStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tripStatus
     * @return \StructType\TripItemResult_V5
     */
    public function setTripStatus($tripStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTripStatus::valueIsValid($tripStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tripStatus, implode(', ', \EnumType\EnumTripStatus::getValidValues())), __LINE__);
        }
        $this->TripStatus = $tripStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TripItemResult_V5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
