<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripInsert StructType
 * @subpackage Structs
 */
class TripInsert extends Trip
{
    /**
     * The SalesPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SalesPrice;
    /**
     * The Places
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPlaceInsert
     */
    public $Places;
    /**
     * The PlanningConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningConfig
     */
    public $PlanningConfig;
    /**
     * Constructor method for TripInsert
     * @uses TripInsert::setSalesPrice()
     * @uses TripInsert::setPlaces()
     * @uses TripInsert::setPlanningConfig()
     * @param float $salesPrice
     * @param \ArrayType\ArrayOfPlaceInsert $places
     * @param \StructType\PlanningConfig $planningConfig
     */
    public function __construct($salesPrice = null, \ArrayType\ArrayOfPlaceInsert $places = null, \StructType\PlanningConfig $planningConfig = null)
    {
        $this
            ->setSalesPrice($salesPrice)
            ->setPlaces($places)
            ->setPlanningConfig($planningConfig);
    }
    /**
     * Get SalesPrice value
     * @return float
     */
    public function getSalesPrice()
    {
        return $this->SalesPrice;
    }
    /**
     * Set SalesPrice value
     * @param float $salesPrice
     * @return \StructType\TripInsert
     */
    public function setSalesPrice($salesPrice = null)
    {
        $this->SalesPrice = $salesPrice;
        return $this;
    }
    /**
     * Get Places value
     * @return \ArrayType\ArrayOfPlaceInsert|null
     */
    public function getPlaces()
    {
        return $this->Places;
    }
    /**
     * Set Places value
     * @param \ArrayType\ArrayOfPlaceInsert $places
     * @return \StructType\TripInsert
     */
    public function setPlaces(\ArrayType\ArrayOfPlaceInsert $places = null)
    {
        $this->Places = $places;
        return $this;
    }
    /**
     * Get PlanningConfig value
     * @return \StructType\PlanningConfig|null
     */
    public function getPlanningConfig()
    {
        return $this->PlanningConfig;
    }
    /**
     * Set PlanningConfig value
     * @param \StructType\PlanningConfig $planningConfig
     * @return \StructType\TripInsert
     */
    public function setPlanningConfig(\StructType\PlanningConfig $planningConfig = null)
    {
        $this->PlanningConfig = $planningConfig;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TripInsert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
