<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextMessageOutbox_V4 StructType
 * @subpackage Structs
 */
class TextMessageOutbox_V4 extends TextMessage
{
    /**
     * The TextMessageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TextMessageID;
    /**
     * The DeliveredDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeliveredDate;
    /**
     * The CreationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The ModifiedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModifiedDate;
    /**
     * The ArrivalDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The Read
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Read;
    /**
     * The ReadDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReadDate;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The ForceOBCWakeUp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ForceOBCWakeUp;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Trailer;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The Dispatcher
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Dispatcher;
    /**
     * The InboxMessageRepliedFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TextMessageInbox_V4
     */
    public $InboxMessageRepliedFrom;
    /**
     * The RepliesOnOutboxMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTextMessageInbox_V4
     */
    public $RepliesOnOutboxMessage;
    /**
     * Constructor method for TextMessageOutbox_V4
     * @uses TextMessageOutbox_V4::setTextMessageID()
     * @uses TextMessageOutbox_V4::setDeliveredDate()
     * @uses TextMessageOutbox_V4::setCreationDate()
     * @uses TextMessageOutbox_V4::setModifiedDate()
     * @uses TextMessageOutbox_V4::setArrivalDateTime()
     * @uses TextMessageOutbox_V4::setRead()
     * @uses TextMessageOutbox_V4::setReadDate()
     * @uses TextMessageOutbox_V4::setStatus()
     * @uses TextMessageOutbox_V4::setForceOBCWakeUp()
     * @uses TextMessageOutbox_V4::setVehicle()
     * @uses TextMessageOutbox_V4::setTrailer()
     * @uses TextMessageOutbox_V4::setDriver()
     * @uses TextMessageOutbox_V4::setDispatcher()
     * @uses TextMessageOutbox_V4::setInboxMessageRepliedFrom()
     * @uses TextMessageOutbox_V4::setRepliesOnOutboxMessage()
     * @param int $textMessageID
     * @param string $deliveredDate
     * @param string $creationDate
     * @param string $modifiedDate
     * @param string $arrivalDateTime
     * @param bool $read
     * @param string $readDate
     * @param string $status
     * @param bool $forceOBCWakeUp
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierVehicleResult_V2 $trailer
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierPerson_V2 $dispatcher
     * @param \StructType\TextMessageInbox_V4 $inboxMessageRepliedFrom
     * @param \ArrayType\ArrayOfTextMessageInbox_V4 $repliesOnOutboxMessage
     */
    public function __construct($textMessageID = null, $deliveredDate = null, $creationDate = null, $modifiedDate = null, $arrivalDateTime = null, $read = null, $readDate = null, $status = null, $forceOBCWakeUp = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierVehicleResult_V2 $trailer = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierPerson_V2 $dispatcher = null, \StructType\TextMessageInbox_V4 $inboxMessageRepliedFrom = null, \ArrayType\ArrayOfTextMessageInbox_V4 $repliesOnOutboxMessage = null)
    {
        $this
            ->setTextMessageID($textMessageID)
            ->setDeliveredDate($deliveredDate)
            ->setCreationDate($creationDate)
            ->setModifiedDate($modifiedDate)
            ->setArrivalDateTime($arrivalDateTime)
            ->setRead($read)
            ->setReadDate($readDate)
            ->setStatus($status)
            ->setForceOBCWakeUp($forceOBCWakeUp)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setDispatcher($dispatcher)
            ->setInboxMessageRepliedFrom($inboxMessageRepliedFrom)
            ->setRepliesOnOutboxMessage($repliesOnOutboxMessage);
    }
    /**
     * Get TextMessageID value
     * @return int
     */
    public function getTextMessageID()
    {
        return $this->TextMessageID;
    }
    /**
     * Set TextMessageID value
     * @param int $textMessageID
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setTextMessageID($textMessageID = null)
    {
        // validation for constraint: int
        if (!is_null($textMessageID) && !is_numeric($textMessageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($textMessageID)), __LINE__);
        }
        $this->TextMessageID = $textMessageID;
        return $this;
    }
    /**
     * Get DeliveredDate value
     * @return string
     */
    public function getDeliveredDate()
    {
        return $this->DeliveredDate;
    }
    /**
     * Set DeliveredDate value
     * @param string $deliveredDate
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setDeliveredDate($deliveredDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveredDate) && !is_string($deliveredDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveredDate)), __LINE__);
        }
        $this->DeliveredDate = $deliveredDate;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get Read value
     * @return bool
     */
    public function getRead()
    {
        return $this->Read;
    }
    /**
     * Set Read value
     * @param bool $read
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setRead($read = null)
    {
        // validation for constraint: boolean
        if (!is_null($read) && !is_bool($read)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($read)), __LINE__);
        }
        $this->Read = $read;
        return $this;
    }
    /**
     * Get ReadDate value
     * @return string
     */
    public function getReadDate()
    {
        return $this->ReadDate;
    }
    /**
     * Set ReadDate value
     * @param string $readDate
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setReadDate($readDate = null)
    {
        // validation for constraint: string
        if (!is_null($readDate) && !is_string($readDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readDate)), __LINE__);
        }
        $this->ReadDate = $readDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumTextMessageStatus::valueIsValid()
     * @uses \EnumType\EnumTextMessageStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTextMessageStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\EnumTextMessageStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ForceOBCWakeUp value
     * @return bool
     */
    public function getForceOBCWakeUp()
    {
        return $this->ForceOBCWakeUp;
    }
    /**
     * Set ForceOBCWakeUp value
     * @param bool $forceOBCWakeUp
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setForceOBCWakeUp($forceOBCWakeUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceOBCWakeUp) && !is_bool($forceOBCWakeUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forceOBCWakeUp)), __LINE__);
        }
        $this->ForceOBCWakeUp = $forceOBCWakeUp;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult_V2 $trailer
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setTrailer(\StructType\IdentifierVehicleResult_V2 $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param \StructType\IdentifierPerson_V2 $dispatcher
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setDispatcher(\StructType\IdentifierPerson_V2 $dispatcher = null)
    {
        $this->Dispatcher = $dispatcher;
        return $this;
    }
    /**
     * Get InboxMessageRepliedFrom value
     * @return \StructType\TextMessageInbox_V4|null
     */
    public function getInboxMessageRepliedFrom()
    {
        return $this->InboxMessageRepliedFrom;
    }
    /**
     * Set InboxMessageRepliedFrom value
     * @param \StructType\TextMessageInbox_V4 $inboxMessageRepliedFrom
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setInboxMessageRepliedFrom(\StructType\TextMessageInbox_V4 $inboxMessageRepliedFrom = null)
    {
        $this->InboxMessageRepliedFrom = $inboxMessageRepliedFrom;
        return $this;
    }
    /**
     * Get RepliesOnOutboxMessage value
     * @return \ArrayType\ArrayOfTextMessageInbox_V4|null
     */
    public function getRepliesOnOutboxMessage()
    {
        return $this->RepliesOnOutboxMessage;
    }
    /**
     * Set RepliesOnOutboxMessage value
     * @param \ArrayType\ArrayOfTextMessageInbox_V4 $repliesOnOutboxMessage
     * @return \StructType\TextMessageOutbox_V4
     */
    public function setRepliesOnOutboxMessage(\ArrayType\ArrayOfTextMessageInbox_V4 $repliesOnOutboxMessage = null)
    {
        $this->RepliesOnOutboxMessage = $repliesOnOutboxMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TextMessageOutbox_V4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
