<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureSetting StructType
 * @subpackage Structs
 */
class TemperatureSetting extends AbstractStructBase
{
    /**
     * The MinValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MinValue;
    /**
     * The MaxValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxValue;
    /**
     * The Zone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Zone;
    /**
     * Constructor method for TemperatureSetting
     * @uses TemperatureSetting::setMinValue()
     * @uses TemperatureSetting::setMaxValue()
     * @uses TemperatureSetting::setZone()
     * @param float $minValue
     * @param float $maxValue
     * @param string $zone
     */
    public function __construct($minValue = null, $maxValue = null, $zone = null)
    {
        $this
            ->setMinValue($minValue)
            ->setMaxValue($maxValue)
            ->setZone($zone);
    }
    /**
     * Get MinValue value
     * @return float
     */
    public function getMinValue()
    {
        return $this->MinValue;
    }
    /**
     * Set MinValue value
     * @param float $minValue
     * @return \StructType\TemperatureSetting
     */
    public function setMinValue($minValue = null)
    {
        $this->MinValue = $minValue;
        return $this;
    }
    /**
     * Get MaxValue value
     * @return float
     */
    public function getMaxValue()
    {
        return $this->MaxValue;
    }
    /**
     * Set MaxValue value
     * @param float $maxValue
     * @return \StructType\TemperatureSetting
     */
    public function setMaxValue($maxValue = null)
    {
        $this->MaxValue = $maxValue;
        return $this;
    }
    /**
     * Get Zone value
     * @return string
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @uses \EnumType\EnumTemperatureZone::valueIsValid()
     * @uses \EnumType\EnumTemperatureZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zone
     * @return \StructType\TemperatureSetting
     */
    public function setZone($zone = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTemperatureZone::valueIsValid($zone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $zone, implode(', ', \EnumType\EnumTemperatureZone::getValidValues())), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TemperatureSetting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
