<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureResult_With_Trailer_Info StructType
 * @subpackage Structs
 */
class TemperatureResult_With_Trailer_Info extends AbstractStructBase
{
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Measurements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTemperatureMeasurement
     */
    public $Measurements;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * Constructor method for TemperatureResult_With_Trailer_Info
     * @uses TemperatureResult_With_Trailer_Info::setVehicle()
     * @uses TemperatureResult_With_Trailer_Info::setMeasurements()
     * @uses TemperatureResult_With_Trailer_Info::setTrailer()
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \ArrayType\ArrayOfTemperatureMeasurement $measurements
     * @param \StructType\IdentifierVehicleResult $trailer
     */
    public function __construct(\StructType\IdentifierVehicleResult $vehicle = null, \ArrayType\ArrayOfTemperatureMeasurement $measurements = null, \StructType\IdentifierVehicleResult $trailer = null)
    {
        $this
            ->setVehicle($vehicle)
            ->setMeasurements($measurements)
            ->setTrailer($trailer);
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\TemperatureResult_With_Trailer_Info
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Measurements value
     * @return \ArrayType\ArrayOfTemperatureMeasurement|null
     */
    public function getMeasurements()
    {
        return $this->Measurements;
    }
    /**
     * Set Measurements value
     * @param \ArrayType\ArrayOfTemperatureMeasurement $measurements
     * @return \StructType\TemperatureResult_With_Trailer_Info
     */
    public function setMeasurements(\ArrayType\ArrayOfTemperatureMeasurement $measurements = null)
    {
        $this->Measurements = $measurements;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\TemperatureResult_With_Trailer_Info
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TemperatureResult_With_Trailer_Info
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
