<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureInformation StructType
 * @subpackage Structs
 */
class TemperatureInformation extends AbstractStructBase
{
    /**
     * The Zone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Zone;
    /**
     * The MinimumTemperature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MinimumTemperature;
    /**
     * The MaximumTemperature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaximumTemperature;
    /**
     * The CurrentTemperature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CurrentTemperature;
    /**
     * The TemperatureType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TemperatureType;
    /**
     * Constructor method for TemperatureInformation
     * @uses TemperatureInformation::setZone()
     * @uses TemperatureInformation::setMinimumTemperature()
     * @uses TemperatureInformation::setMaximumTemperature()
     * @uses TemperatureInformation::setCurrentTemperature()
     * @uses TemperatureInformation::setTemperatureType()
     * @param int $zone
     * @param float $minimumTemperature
     * @param float $maximumTemperature
     * @param float $currentTemperature
     * @param string $temperatureType
     */
    public function __construct($zone = null, $minimumTemperature = null, $maximumTemperature = null, $currentTemperature = null, $temperatureType = null)
    {
        $this
            ->setZone($zone)
            ->setMinimumTemperature($minimumTemperature)
            ->setMaximumTemperature($maximumTemperature)
            ->setCurrentTemperature($currentTemperature)
            ->setTemperatureType($temperatureType);
    }
    /**
     * Get Zone value
     * @return int
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \StructType\TemperatureInformation
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !is_numeric($zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * @return float
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }
    /**
     * Set MinimumTemperature value
     * @param float $minimumTemperature
     * @return \StructType\TemperatureInformation
     */
    public function setMinimumTemperature($minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * @return float
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }
    /**
     * Set MaximumTemperature value
     * @param float $maximumTemperature
     * @return \StructType\TemperatureInformation
     */
    public function setMaximumTemperature($maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get CurrentTemperature value
     * @return float
     */
    public function getCurrentTemperature()
    {
        return $this->CurrentTemperature;
    }
    /**
     * Set CurrentTemperature value
     * @param float $currentTemperature
     * @return \StructType\TemperatureInformation
     */
    public function setCurrentTemperature($currentTemperature = null)
    {
        $this->CurrentTemperature = $currentTemperature;
        return $this;
    }
    /**
     * Get TemperatureType value
     * @return string
     */
    public function getTemperatureType()
    {
        return $this->TemperatureType;
    }
    /**
     * Set TemperatureType value
     * @uses \EnumType\EnumTemperatureType::valueIsValid()
     * @uses \EnumType\EnumTemperatureType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $temperatureType
     * @return \StructType\TemperatureInformation
     */
    public function setTemperatureType($temperatureType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTemperatureType::valueIsValid($temperatureType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $temperatureType, implode(', ', \EnumType\EnumTemperatureType::getValidValues())), __LINE__);
        }
        $this->TemperatureType = $temperatureType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TemperatureInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
