<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Temperature StructType
 * @subpackage Structs
 */
class Temperature extends AbstractStructBase
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The Minimum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Minimum;
    /**
     * The Maximum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Maximum;
    /**
     * Constructor method for Temperature
     * @uses Temperature::setValue()
     * @uses Temperature::setMinimum()
     * @uses Temperature::setMaximum()
     * @param float $value
     * @param float $minimum
     * @param float $maximum
     */
    public function __construct($value = null, $minimum = null, $maximum = null)
    {
        $this
            ->setValue($value)
            ->setMinimum($minimum)
            ->setMaximum($maximum);
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\Temperature
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Minimum value
     * @return float
     */
    public function getMinimum()
    {
        return $this->Minimum;
    }
    /**
     * Set Minimum value
     * @param float $minimum
     * @return \StructType\Temperature
     */
    public function setMinimum($minimum = null)
    {
        $this->Minimum = $minimum;
        return $this;
    }
    /**
     * Get Maximum value
     * @return float
     */
    public function getMaximum()
    {
        return $this->Maximum;
    }
    /**
     * Set Maximum value
     * @param float $maximum
     * @return \StructType\Temperature
     */
    public function setMaximum($maximum = null)
    {
        $this->Maximum = $maximum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Temperature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
