<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TachoReadoutItem StructType
 * @subpackage Structs
 */
class TachoReadoutItem extends AbstractStructBase
{
    /**
     * The ModificationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ModificationId;
    /**
     * The CreationDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The StartDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDateTime;
    /**
     * The EndDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDateTime;
    /**
     * The Group
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GroupIdentifierResult
     */
    public $Group;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The FileContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileContent;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * Constructor method for TachoReadoutItem
     * @uses TachoReadoutItem::setModificationId()
     * @uses TachoReadoutItem::setCreationDateTime()
     * @uses TachoReadoutItem::setStartDateTime()
     * @uses TachoReadoutItem::setEndDateTime()
     * @uses TachoReadoutItem::setGroup()
     * @uses TachoReadoutItem::setFileName()
     * @uses TachoReadoutItem::setFileContent()
     * @uses TachoReadoutItem::setVehicle()
     * @uses TachoReadoutItem::setDriver()
     * @param int $modificationId
     * @param string $creationDateTime
     * @param string $startDateTime
     * @param string $endDateTime
     * @param \StructType\GroupIdentifierResult $group
     * @param string $fileName
     * @param string $fileContent
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierPerson_V2 $driver
     */
    public function __construct($modificationId = null, $creationDateTime = null, $startDateTime = null, $endDateTime = null, \StructType\GroupIdentifierResult $group = null, $fileName = null, $fileContent = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierPerson_V2 $driver = null)
    {
        $this
            ->setModificationId($modificationId)
            ->setCreationDateTime($creationDateTime)
            ->setStartDateTime($startDateTime)
            ->setEndDateTime($endDateTime)
            ->setGroup($group)
            ->setFileName($fileName)
            ->setFileContent($fileContent)
            ->setVehicle($vehicle)
            ->setDriver($driver);
    }
    /**
     * Get ModificationId value
     * @return int
     */
    public function getModificationId()
    {
        return $this->ModificationId;
    }
    /**
     * Set ModificationId value
     * @param int $modificationId
     * @return \StructType\TachoReadoutItem
     */
    public function setModificationId($modificationId = null)
    {
        // validation for constraint: int
        if (!is_null($modificationId) && !is_numeric($modificationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($modificationId)), __LINE__);
        }
        $this->ModificationId = $modificationId;
        return $this;
    }
    /**
     * Get CreationDateTime value
     * @return string
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\TachoReadoutItem
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDateTime)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get StartDateTime value
     * @return string
     */
    public function getStartDateTime()
    {
        return $this->StartDateTime;
    }
    /**
     * Set StartDateTime value
     * @param string $startDateTime
     * @return \StructType\TachoReadoutItem
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDateTime)), __LINE__);
        }
        $this->StartDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get EndDateTime value
     * @return string
     */
    public function getEndDateTime()
    {
        return $this->EndDateTime;
    }
    /**
     * Set EndDateTime value
     * @param string $endDateTime
     * @return \StructType\TachoReadoutItem
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDateTime)), __LINE__);
        }
        $this->EndDateTime = $endDateTime;
        return $this;
    }
    /**
     * Get Group value
     * @return \StructType\GroupIdentifierResult|null
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param \StructType\GroupIdentifierResult $group
     * @return \StructType\TachoReadoutItem
     */
    public function setGroup(\StructType\GroupIdentifierResult $group = null)
    {
        $this->Group = $group;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\TachoReadoutItem
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get FileContent value
     * @return string|null
     */
    public function getFileContent()
    {
        return $this->FileContent;
    }
    /**
     * Set FileContent value
     * @param string $fileContent
     * @return \StructType\TachoReadoutItem
     */
    public function setFileContent($fileContent = null)
    {
        // validation for constraint: string
        if (!is_null($fileContent) && !is_string($fileContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileContent)), __LINE__);
        }
        $this->FileContent = $fileContent;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\TachoReadoutItem
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\TachoReadoutItem
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TachoReadoutItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
