<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TachoCardInfo StructType
 * @subpackage Structs
 */
class TachoCardInfo extends AbstractStructBase
{
    /**
     * The TachoCardDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TachoCardDate;
    /**
     * The TachoCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TachoCard;
    /**
     * Constructor method for TachoCardInfo
     * @uses TachoCardInfo::setTachoCardDate()
     * @uses TachoCardInfo::setTachoCard()
     * @param string $tachoCardDate
     * @param string $tachoCard
     */
    public function __construct($tachoCardDate = null, $tachoCard = null)
    {
        $this
            ->setTachoCardDate($tachoCardDate)
            ->setTachoCard($tachoCard);
    }
    /**
     * Get TachoCardDate value
     * @return string
     */
    public function getTachoCardDate()
    {
        return $this->TachoCardDate;
    }
    /**
     * Set TachoCardDate value
     * @param string $tachoCardDate
     * @return \StructType\TachoCardInfo
     */
    public function setTachoCardDate($tachoCardDate = null)
    {
        // validation for constraint: string
        if (!is_null($tachoCardDate) && !is_string($tachoCardDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tachoCardDate)), __LINE__);
        }
        $this->TachoCardDate = $tachoCardDate;
        return $this;
    }
    /**
     * Get TachoCard value
     * @return string|null
     */
    public function getTachoCard()
    {
        return $this->TachoCard;
    }
    /**
     * Set TachoCard value
     * @param string $tachoCard
     * @return \StructType\TachoCardInfo
     */
    public function setTachoCard($tachoCard = null)
    {
        // validation for constraint: string
        if (!is_null($tachoCard) && !is_string($tachoCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tachoCard)), __LINE__);
        }
        $this->TachoCard = $tachoCard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TachoCardInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
