<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StreetInfoResult StructType
 * @subpackage Structs
 */
class StreetInfoResult extends StreetInfo
{
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The StreetLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $StreetLevel;
    /**
     * Constructor method for StreetInfoResult
     * @uses StreetInfoResult::setLongitude()
     * @uses StreetInfoResult::setLatitude()
     * @uses StreetInfoResult::setStreetLevel()
     * @param float $longitude
     * @param float $latitude
     * @param bool $streetLevel
     */
    public function __construct($longitude = null, $latitude = null, $streetLevel = null)
    {
        $this
            ->setLongitude($longitude)
            ->setLatitude($latitude)
            ->setStreetLevel($streetLevel);
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\StreetInfoResult
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\StreetInfoResult
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get StreetLevel value
     * @return bool
     */
    public function getStreetLevel()
    {
        return $this->StreetLevel;
    }
    /**
     * Set StreetLevel value
     * @param bool $streetLevel
     * @return \StructType\StreetInfoResult
     */
    public function setStreetLevel($streetLevel = null)
    {
        // validation for constraint: boolean
        if (!is_null($streetLevel) && !is_bool($streetLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($streetLevel)), __LINE__);
        }
        $this->StreetLevel = $streetLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StreetInfoResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
