<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceTimeTachoDetail_V5 StructType
 * @subpackage Structs
 */
class ServiceTimeTachoDetail_V5 extends AbstractStructBase
{
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ModificationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The KmsEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmsEnd;
    /**
     * The KmsStart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmsStart;
    /**
     * The ReadOutDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReadOutDate;
    /**
     * The IsCoDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCoDriver;
    /**
     * The TachoID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TachoID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Source;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V3
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The WorkingCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $WorkingCode;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult_V2
     */
    public $Position;
    /**
     * Constructor method for ServiceTimeTachoDetail_V5
     * @uses ServiceTimeTachoDetail_V5::setBeginDate()
     * @uses ServiceTimeTachoDetail_V5::setEndDate()
     * @uses ServiceTimeTachoDetail_V5::setModificationDate()
     * @uses ServiceTimeTachoDetail_V5::setKmsEnd()
     * @uses ServiceTimeTachoDetail_V5::setKmsStart()
     * @uses ServiceTimeTachoDetail_V5::setReadOutDate()
     * @uses ServiceTimeTachoDetail_V5::setIsCoDriver()
     * @uses ServiceTimeTachoDetail_V5::setTachoID()
     * @uses ServiceTimeTachoDetail_V5::setActive()
     * @uses ServiceTimeTachoDetail_V5::setSource()
     * @uses ServiceTimeTachoDetail_V5::setDriver()
     * @uses ServiceTimeTachoDetail_V5::setVehicle()
     * @uses ServiceTimeTachoDetail_V5::setWorkingCode()
     * @uses ServiceTimeTachoDetail_V5::setPosition()
     * @param string $beginDate
     * @param string $endDate
     * @param string $modificationDate
     * @param int $kmsEnd
     * @param int $kmsStart
     * @param string $readOutDate
     * @param bool $isCoDriver
     * @param int $tachoID
     * @param bool $active
     * @param string $source
     * @param \StructType\IdentifierPerson_V3 $driver
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\CodeInfo $workingCode
     * @param \StructType\PositionResult_V2 $position
     */
    public function __construct($beginDate = null, $endDate = null, $modificationDate = null, $kmsEnd = null, $kmsStart = null, $readOutDate = null, $isCoDriver = null, $tachoID = null, $active = null, $source = null, \StructType\IdentifierPerson_V3 $driver = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\CodeInfo $workingCode = null, \StructType\PositionResult_V2 $position = null)
    {
        $this
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setModificationDate($modificationDate)
            ->setKmsEnd($kmsEnd)
            ->setKmsStart($kmsStart)
            ->setReadOutDate($readOutDate)
            ->setIsCoDriver($isCoDriver)
            ->setTachoID($tachoID)
            ->setActive($active)
            ->setSource($source)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setWorkingCode($workingCode)
            ->setPosition($position);
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get KmsEnd value
     * @return int
     */
    public function getKmsEnd()
    {
        return $this->KmsEnd;
    }
    /**
     * Set KmsEnd value
     * @param int $kmsEnd
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setKmsEnd($kmsEnd = null)
    {
        // validation for constraint: int
        if (!is_null($kmsEnd) && !is_numeric($kmsEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmsEnd)), __LINE__);
        }
        $this->KmsEnd = $kmsEnd;
        return $this;
    }
    /**
     * Get KmsStart value
     * @return int
     */
    public function getKmsStart()
    {
        return $this->KmsStart;
    }
    /**
     * Set KmsStart value
     * @param int $kmsStart
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setKmsStart($kmsStart = null)
    {
        // validation for constraint: int
        if (!is_null($kmsStart) && !is_numeric($kmsStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmsStart)), __LINE__);
        }
        $this->KmsStart = $kmsStart;
        return $this;
    }
    /**
     * Get ReadOutDate value
     * @return string
     */
    public function getReadOutDate()
    {
        return $this->ReadOutDate;
    }
    /**
     * Set ReadOutDate value
     * @param string $readOutDate
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setReadOutDate($readOutDate = null)
    {
        // validation for constraint: string
        if (!is_null($readOutDate) && !is_string($readOutDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readOutDate)), __LINE__);
        }
        $this->ReadOutDate = $readOutDate;
        return $this;
    }
    /**
     * Get IsCoDriver value
     * @return bool
     */
    public function getIsCoDriver()
    {
        return $this->IsCoDriver;
    }
    /**
     * Set IsCoDriver value
     * @param bool $isCoDriver
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setIsCoDriver($isCoDriver = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCoDriver) && !is_bool($isCoDriver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCoDriver)), __LINE__);
        }
        $this->IsCoDriver = $isCoDriver;
        return $this;
    }
    /**
     * Get TachoID value
     * @return int
     */
    public function getTachoID()
    {
        return $this->TachoID;
    }
    /**
     * Set TachoID value
     * @param int $tachoID
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setTachoID($tachoID = null)
    {
        // validation for constraint: int
        if (!is_null($tachoID) && !is_numeric($tachoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tachoID)), __LINE__);
        }
        $this->TachoID = $tachoID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Source value
     * @return string
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @uses \EnumType\EnumSource::valueIsValid()
     * @uses \EnumType\EnumSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $source
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setSource($source = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSource::valueIsValid($source)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $source, implode(', ', \EnumType\EnumSource::getValidValues())), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V3|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V3 $driver
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setDriver(\StructType\IdentifierPerson_V3 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get WorkingCode value
     * @return \StructType\CodeInfo|null
     */
    public function getWorkingCode()
    {
        return $this->WorkingCode;
    }
    /**
     * Set WorkingCode value
     * @param \StructType\CodeInfo $workingCode
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setWorkingCode(\StructType\CodeInfo $workingCode = null)
    {
        $this->WorkingCode = $workingCode;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult_V2|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult_V2 $position
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public function setPosition(\StructType\PositionResult_V2 $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceTimeTachoDetail_V5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
