<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurityCommand StructType
 * @subpackage Structs
 */
class SecurityCommand extends AbstractStructBase
{
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Trailer;
    /**
     * The MasterCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MasterCode;
    /**
     * The VarioCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VarioCode;
    /**
     * Constructor method for SecurityCommand
     * @uses SecurityCommand::setVehicle()
     * @uses SecurityCommand::setTrailer()
     * @uses SecurityCommand::setMasterCode()
     * @uses SecurityCommand::setVarioCode()
     * @param \StructType\IdentifierVehicle $vehicle
     * @param \StructType\IdentifierVehicle $trailer
     * @param string $masterCode
     * @param string $varioCode
     */
    public function __construct(\StructType\IdentifierVehicle $vehicle = null, \StructType\IdentifierVehicle $trailer = null, $masterCode = null, $varioCode = null)
    {
        $this
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setMasterCode($masterCode)
            ->setVarioCode($varioCode);
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\SecurityCommand
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicle $trailer
     * @return \StructType\SecurityCommand
     */
    public function setTrailer(\StructType\IdentifierVehicle $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get MasterCode value
     * @return string|null
     */
    public function getMasterCode()
    {
        return $this->MasterCode;
    }
    /**
     * Set MasterCode value
     * @param string $masterCode
     * @return \StructType\SecurityCommand
     */
    public function setMasterCode($masterCode = null)
    {
        // validation for constraint: string
        if (!is_null($masterCode) && !is_string($masterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($masterCode)), __LINE__);
        }
        $this->MasterCode = $masterCode;
        return $this;
    }
    /**
     * Get VarioCode value
     * @return string|null
     */
    public function getVarioCode()
    {
        return $this->VarioCode;
    }
    /**
     * Set VarioCode value
     * @param string $varioCode
     * @return \StructType\SecurityCommand
     */
    public function setVarioCode($varioCode = null)
    {
        // validation for constraint: string
        if (!is_null($varioCode) && !is_string($varioCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($varioCode)), __LINE__);
        }
        $this->VarioCode = $varioCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SecurityCommand
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
