<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScannedDocumentsSelection_V2 StructType
 * @subpackage Structs
 */
class ScannedDocumentsSelection_V2 extends AbstractStructBase
{
    /**
     * The ScanID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ScanID;
    /**
     * The SelectionFromToday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeAndIdSelection
     */
    public $SelectionFromToday;
    /**
     * The SelectionDateRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $SelectionDateRange;
    /**
     * Constructor method for ScannedDocumentsSelection_V2
     * @uses ScannedDocumentsSelection_V2::setScanID()
     * @uses ScannedDocumentsSelection_V2::setSelectionFromToday()
     * @uses ScannedDocumentsSelection_V2::setSelectionDateRange()
     * @param int $scanID
     * @param \StructType\DateTimeAndIdSelection $selectionFromToday
     * @param \StructType\DateTimeRangeSelection $selectionDateRange
     */
    public function __construct($scanID = null, \StructType\DateTimeAndIdSelection $selectionFromToday = null, \StructType\DateTimeRangeSelection $selectionDateRange = null)
    {
        $this
            ->setScanID($scanID)
            ->setSelectionFromToday($selectionFromToday)
            ->setSelectionDateRange($selectionDateRange);
    }
    /**
     * Get ScanID value
     * @return int
     */
    public function getScanID()
    {
        return $this->ScanID;
    }
    /**
     * Set ScanID value
     * @param int $scanID
     * @return \StructType\ScannedDocumentsSelection_V2
     */
    public function setScanID($scanID = null)
    {
        // validation for constraint: int
        if (!is_null($scanID) && !is_numeric($scanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scanID)), __LINE__);
        }
        $this->ScanID = $scanID;
        return $this;
    }
    /**
     * Get SelectionFromToday value
     * @return \StructType\DateTimeAndIdSelection|null
     */
    public function getSelectionFromToday()
    {
        return $this->SelectionFromToday;
    }
    /**
     * Set SelectionFromToday value
     * @param \StructType\DateTimeAndIdSelection $selectionFromToday
     * @return \StructType\ScannedDocumentsSelection_V2
     */
    public function setSelectionFromToday(\StructType\DateTimeAndIdSelection $selectionFromToday = null)
    {
        $this->SelectionFromToday = $selectionFromToday;
        return $this;
    }
    /**
     * Get SelectionDateRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getSelectionDateRange()
    {
        return $this->SelectionDateRange;
    }
    /**
     * Set SelectionDateRange value
     * @param \StructType\DateTimeRangeSelection $selectionDateRange
     * @return \StructType\ScannedDocumentsSelection_V2
     */
    public function setSelectionDateRange(\StructType\DateTimeRangeSelection $selectionDateRange = null)
    {
        $this->SelectionDateRange = $selectionDateRange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ScannedDocumentsSelection_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
