<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalaryPreCalculationSelection_V2 StructType
 * @subpackage Structs
 */
class SalaryPreCalculationSelection_V2 extends AbstractStructBase
{
    /**
     * The SelectionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SelectionType;
    /**
     * The Drivers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The DateStrategySelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateStrategySelection
     */
    public $DateStrategySelection;
    /**
     * Constructor method for SalaryPreCalculationSelection_V2
     * @uses SalaryPreCalculationSelection_V2::setSelectionType()
     * @uses SalaryPreCalculationSelection_V2::setDrivers()
     * @uses SalaryPreCalculationSelection_V2::setDateStrategySelection()
     * @param string $selectionType
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \StructType\DateStrategySelection $dateStrategySelection
     */
    public function __construct($selectionType = null, \ArrayType\ArrayOfIdentifier $drivers = null, \StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this
            ->setSelectionType($selectionType)
            ->setDrivers($drivers)
            ->setDateStrategySelection($dateStrategySelection);
    }
    /**
     * Get SelectionType value
     * @return string
     */
    public function getSelectionType()
    {
        return $this->SelectionType;
    }
    /**
     * Set SelectionType value
     * @uses \EnumType\EnumSelectionType::valueIsValid()
     * @uses \EnumType\EnumSelectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionType
     * @return \StructType\SalaryPreCalculationSelection_V2
     */
    public function setSelectionType($selectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSelectionType::valueIsValid($selectionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $selectionType, implode(', ', \EnumType\EnumSelectionType::getValidValues())), __LINE__);
        }
        $this->SelectionType = $selectionType;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\SalaryPreCalculationSelection_V2
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get DateStrategySelection value
     * @return \StructType\DateStrategySelection|null
     */
    public function getDateStrategySelection()
    {
        return $this->DateStrategySelection;
    }
    /**
     * Set DateStrategySelection value
     * @param \StructType\DateStrategySelection $dateStrategySelection
     * @return \StructType\SalaryPreCalculationSelection_V2
     */
    public function setDateStrategySelection(\StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this->DateStrategySelection = $dateStrategySelection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SalaryPreCalculationSelection_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
