<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveGroupFromDispatcher StructType
 * @subpackage Structs
 */
class RemoveGroupFromDispatcher extends AbstractStructBase
{
    /**
     * The GroupType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GroupType;
    /**
     * The GroupCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The SubGroupCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupCode;
    /**
     * The Dispatcher
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Dispatcher;
    /**
     * Constructor method for RemoveGroupFromDispatcher
     * @uses RemoveGroupFromDispatcher::setGroupType()
     * @uses RemoveGroupFromDispatcher::setGroupCode()
     * @uses RemoveGroupFromDispatcher::setSubGroupCode()
     * @uses RemoveGroupFromDispatcher::setDispatcher()
     * @param string $groupType
     * @param string $groupCode
     * @param string $subGroupCode
     * @param \StructType\Identifier $dispatcher
     */
    public function __construct($groupType = null, $groupCode = null, $subGroupCode = null, \StructType\Identifier $dispatcher = null)
    {
        $this
            ->setGroupType($groupType)
            ->setGroupCode($groupCode)
            ->setSubGroupCode($subGroupCode)
            ->setDispatcher($dispatcher);
    }
    /**
     * Get GroupType value
     * @return string
     */
    public function getGroupType()
    {
        return $this->GroupType;
    }
    /**
     * Set GroupType value
     * @uses \EnumType\EnumGroupType::valueIsValid()
     * @uses \EnumType\EnumGroupType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupType
     * @return \StructType\RemoveGroupFromDispatcher
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGroupType::valueIsValid($groupType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $groupType, implode(', ', \EnumType\EnumGroupType::getValidValues())), __LINE__);
        }
        $this->GroupType = $groupType;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\RemoveGroupFromDispatcher
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get SubGroupCode value
     * @return string|null
     */
    public function getSubGroupCode()
    {
        return $this->SubGroupCode;
    }
    /**
     * Set SubGroupCode value
     * @param string $subGroupCode
     * @return \StructType\RemoveGroupFromDispatcher
     */
    public function setSubGroupCode($subGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupCode) && !is_string($subGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subGroupCode)), __LINE__);
        }
        $this->SubGroupCode = $subGroupCode;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return \StructType\Identifier|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param \StructType\Identifier $dispatcher
     * @return \StructType\RemoveGroupFromDispatcher
     */
    public function setDispatcher(\StructType\Identifier $dispatcher = null)
    {
        $this->Dispatcher = $dispatcher;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveGroupFromDispatcher
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
