<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemainingDateItem StructType
 * @subpackage Structs
 */
class RemainingDateItem extends AbstractStructBase
{
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Total;
    /**
     * The Maximum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Maximum;
    /**
     * The Remaining
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Remaining;
    /**
     * Constructor method for RemainingDateItem
     * @uses RemainingDateItem::setTotal()
     * @uses RemainingDateItem::setMaximum()
     * @uses RemainingDateItem::setRemaining()
     * @param int $total
     * @param int $maximum
     * @param int $remaining
     */
    public function __construct($total = null, $maximum = null, $remaining = null)
    {
        $this
            ->setTotal($total)
            ->setMaximum($maximum)
            ->setRemaining($remaining);
    }
    /**
     * Get Total value
     * @return int
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param int $total
     * @return \StructType\RemainingDateItem
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Maximum value
     * @return int
     */
    public function getMaximum()
    {
        return $this->Maximum;
    }
    /**
     * Set Maximum value
     * @param int $maximum
     * @return \StructType\RemainingDateItem
     */
    public function setMaximum($maximum = null)
    {
        // validation for constraint: int
        if (!is_null($maximum) && !is_numeric($maximum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximum)), __LINE__);
        }
        $this->Maximum = $maximum;
        return $this;
    }
    /**
     * Get Remaining value
     * @return int
     */
    public function getRemaining()
    {
        return $this->Remaining;
    }
    /**
     * Set Remaining value
     * @param int $remaining
     * @return \StructType\RemainingDateItem
     */
    public function setRemaining($remaining = null)
    {
        // validation for constraint: int
        if (!is_null($remaining) && !is_numeric($remaining)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($remaining)), __LINE__);
        }
        $this->Remaining = $remaining;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemainingDateItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
