<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Registration_v2 StructType
 * @subpackage Structs
 */
class Registration_v2 extends AbstractStructBase
{
    /**
     * The Export
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Export;
    /**
     * The Consumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Consumption;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ExportDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExportDate;
    /**
     * The Modified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modified;
    /**
     * The InterfaceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $InterfaceInfo;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Source;
    /**
     * The KmsBegin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $KmsBegin;
    /**
     * The kmsEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $kmsEnd;
    /**
     * The PlaceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceInfo;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The QuestionPathInfos
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfQuestionPathInfo_v2
     */
    public $QuestionPathInfos;
    /**
     * Constructor method for Registration_v2
     * @uses Registration_v2::setExport()
     * @uses Registration_v2::setConsumption()
     * @uses Registration_v2::setBeginDate()
     * @uses Registration_v2::setEndDate()
     * @uses Registration_v2::setExportDate()
     * @uses Registration_v2::setModified()
     * @uses Registration_v2::setInterfaceInfo()
     * @uses Registration_v2::setSource()
     * @uses Registration_v2::setKmsBegin()
     * @uses Registration_v2::setKmsEnd()
     * @uses Registration_v2::setPlaceInfo()
     * @uses Registration_v2::setCountryCode()
     * @uses Registration_v2::setPosition()
     * @uses Registration_v2::setActivity()
     * @uses Registration_v2::setQuestionPathInfos()
     * @param bool $export
     * @param float $consumption
     * @param string $beginDate
     * @param string $endDate
     * @param string $exportDate
     * @param string $modified
     * @param int $interfaceInfo
     * @param string $source
     * @param int $kmsBegin
     * @param int $kmsEnd
     * @param string $placeInfo
     * @param string $countryCode
     * @param \StructType\Position $position
     * @param \StructType\Activity $activity
     * @param \ArrayType\ArrayOfQuestionPathInfo_v2 $questionPathInfos
     */
    public function __construct($export = null, $consumption = null, $beginDate = null, $endDate = null, $exportDate = null, $modified = null, $interfaceInfo = null, $source = null, $kmsBegin = null, $kmsEnd = null, $placeInfo = null, $countryCode = null, \StructType\Position $position = null, \StructType\Activity $activity = null, \ArrayType\ArrayOfQuestionPathInfo_v2 $questionPathInfos = null)
    {
        $this
            ->setExport($export)
            ->setConsumption($consumption)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setExportDate($exportDate)
            ->setModified($modified)
            ->setInterfaceInfo($interfaceInfo)
            ->setSource($source)
            ->setKmsBegin($kmsBegin)
            ->setKmsEnd($kmsEnd)
            ->setPlaceInfo($placeInfo)
            ->setCountryCode($countryCode)
            ->setPosition($position)
            ->setActivity($activity)
            ->setQuestionPathInfos($questionPathInfos);
    }
    /**
     * Get Export value
     * @return bool
     */
    public function getExport()
    {
        return $this->Export;
    }
    /**
     * Set Export value
     * @param bool $export
     * @return \StructType\Registration_v2
     */
    public function setExport($export = null)
    {
        // validation for constraint: boolean
        if (!is_null($export) && !is_bool($export)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($export)), __LINE__);
        }
        $this->Export = $export;
        return $this;
    }
    /**
     * Get Consumption value
     * @return float
     */
    public function getConsumption()
    {
        return $this->Consumption;
    }
    /**
     * Set Consumption value
     * @param float $consumption
     * @return \StructType\Registration_v2
     */
    public function setConsumption($consumption = null)
    {
        $this->Consumption = $consumption;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\Registration_v2
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\Registration_v2
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ExportDate value
     * @return string
     */
    public function getExportDate()
    {
        return $this->ExportDate;
    }
    /**
     * Set ExportDate value
     * @param string $exportDate
     * @return \StructType\Registration_v2
     */
    public function setExportDate($exportDate = null)
    {
        // validation for constraint: string
        if (!is_null($exportDate) && !is_string($exportDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exportDate)), __LINE__);
        }
        $this->ExportDate = $exportDate;
        return $this;
    }
    /**
     * Get Modified value
     * @return string
     */
    public function getModified()
    {
        return $this->Modified;
    }
    /**
     * Set Modified value
     * @param string $modified
     * @return \StructType\Registration_v2
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modified)), __LINE__);
        }
        $this->Modified = $modified;
        return $this;
    }
    /**
     * Get InterfaceInfo value
     * @return int
     */
    public function getInterfaceInfo()
    {
        return $this->InterfaceInfo;
    }
    /**
     * Set InterfaceInfo value
     * @param int $interfaceInfo
     * @return \StructType\Registration_v2
     */
    public function setInterfaceInfo($interfaceInfo = null)
    {
        // validation for constraint: int
        if (!is_null($interfaceInfo) && !is_numeric($interfaceInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($interfaceInfo)), __LINE__);
        }
        $this->InterfaceInfo = $interfaceInfo;
        return $this;
    }
    /**
     * Get Source value
     * @return string
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @uses \EnumType\EnumRegistrationSource::valueIsValid()
     * @uses \EnumType\EnumRegistrationSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $source
     * @return \StructType\Registration_v2
     */
    public function setSource($source = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumRegistrationSource::valueIsValid($source)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $source, implode(', ', \EnumType\EnumRegistrationSource::getValidValues())), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get KmsBegin value
     * @return int
     */
    public function getKmsBegin()
    {
        return $this->KmsBegin;
    }
    /**
     * Set KmsBegin value
     * @param int $kmsBegin
     * @return \StructType\Registration_v2
     */
    public function setKmsBegin($kmsBegin = null)
    {
        // validation for constraint: int
        if (!is_null($kmsBegin) && !is_numeric($kmsBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmsBegin)), __LINE__);
        }
        $this->KmsBegin = $kmsBegin;
        return $this;
    }
    /**
     * Get kmsEnd value
     * @return int
     */
    public function getKmsEnd()
    {
        return $this->kmsEnd;
    }
    /**
     * Set kmsEnd value
     * @param int $kmsEnd
     * @return \StructType\Registration_v2
     */
    public function setKmsEnd($kmsEnd = null)
    {
        // validation for constraint: int
        if (!is_null($kmsEnd) && !is_numeric($kmsEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmsEnd)), __LINE__);
        }
        $this->kmsEnd = $kmsEnd;
        return $this;
    }
    /**
     * Get PlaceInfo value
     * @return string|null
     */
    public function getPlaceInfo()
    {
        return $this->PlaceInfo;
    }
    /**
     * Set PlaceInfo value
     * @param string $placeInfo
     * @return \StructType\Registration_v2
     */
    public function setPlaceInfo($placeInfo = null)
    {
        // validation for constraint: string
        if (!is_null($placeInfo) && !is_string($placeInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeInfo)), __LINE__);
        }
        $this->PlaceInfo = $placeInfo;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\Registration_v2
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\Registration_v2
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\Registration_v2
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get QuestionPathInfos value
     * @return \ArrayType\ArrayOfQuestionPathInfo_v2|null
     */
    public function getQuestionPathInfos()
    {
        return $this->QuestionPathInfos;
    }
    /**
     * Set QuestionPathInfos value
     * @param \ArrayType\ArrayOfQuestionPathInfo_v2 $questionPathInfos
     * @return \StructType\Registration_v2
     */
    public function setQuestionPathInfos(\ArrayType\ArrayOfQuestionPathInfo_v2 $questionPathInfos = null)
    {
        $this->QuestionPathInfos = $questionPathInfos;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Registration_v2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
