<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefuelReportSelection_V3 StructType
 * @subpackage Structs
 */
class RefuelReportSelection_V3 extends AbstractStructBase
{
    /**
     * The CountryCodeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CountryCodeType;
    /**
     * The Vehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The DateStrategySelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateStrategySelection
     */
    public $DateStrategySelection;
    /**
     * The FuelTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $FuelTypes;
    /**
     * Constructor method for RefuelReportSelection_V3
     * @uses RefuelReportSelection_V3::setCountryCodeType()
     * @uses RefuelReportSelection_V3::setVehicles()
     * @uses RefuelReportSelection_V3::setDateStrategySelection()
     * @uses RefuelReportSelection_V3::setFuelTypes()
     * @param string $countryCodeType
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \StructType\DateStrategySelection $dateStrategySelection
     * @param \ArrayType\ArrayOfInt $fuelTypes
     */
    public function __construct($countryCodeType = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \StructType\DateStrategySelection $dateStrategySelection = null, \ArrayType\ArrayOfInt $fuelTypes = null)
    {
        $this
            ->setCountryCodeType($countryCodeType)
            ->setVehicles($vehicles)
            ->setDateStrategySelection($dateStrategySelection)
            ->setFuelTypes($fuelTypes);
    }
    /**
     * Get CountryCodeType value
     * @return string
     */
    public function getCountryCodeType()
    {
        return $this->CountryCodeType;
    }
    /**
     * Set CountryCodeType value
     * @uses \EnumType\CountryCodeTypes::valueIsValid()
     * @uses \EnumType\CountryCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $countryCodeType
     * @return \StructType\RefuelReportSelection_V3
     */
    public function setCountryCodeType($countryCodeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryCodeTypes::valueIsValid($countryCodeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $countryCodeType, implode(', ', \EnumType\CountryCodeTypes::getValidValues())), __LINE__);
        }
        $this->CountryCodeType = $countryCodeType;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\RefuelReportSelection_V3
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get DateStrategySelection value
     * @return \StructType\DateStrategySelection|null
     */
    public function getDateStrategySelection()
    {
        return $this->DateStrategySelection;
    }
    /**
     * Set DateStrategySelection value
     * @param \StructType\DateStrategySelection $dateStrategySelection
     * @return \StructType\RefuelReportSelection_V3
     */
    public function setDateStrategySelection(\StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this->DateStrategySelection = $dateStrategySelection;
        return $this;
    }
    /**
     * Get FuelTypes value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getFuelTypes()
    {
        return $this->FuelTypes;
    }
    /**
     * Set FuelTypes value
     * @param \ArrayType\ArrayOfInt $fuelTypes
     * @return \StructType\RefuelReportSelection_V3
     */
    public function setFuelTypes(\ArrayType\ArrayOfInt $fuelTypes = null)
    {
        $this->FuelTypes = $fuelTypes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RefuelReportSelection_V3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
