<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuestionPathInfo StructType
 * @subpackage Structs
 */
class QuestionPathInfo extends AbstractStructBase
{
    /**
     * The QuestionPathType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $QuestionPathType;
    /**
     * The AutoClosed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AutoClosed;
    /**
     * The Answer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Answer;
    /**
     * The TreatmentCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $TreatmentCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for QuestionPathInfo
     * @uses QuestionPathInfo::setQuestionPathType()
     * @uses QuestionPathInfo::setAutoClosed()
     * @uses QuestionPathInfo::setAnswer()
     * @uses QuestionPathInfo::setTreatmentCode()
     * @uses QuestionPathInfo::setDescription()
     * @param int $questionPathType
     * @param bool $autoClosed
     * @param string $answer
     * @param \StructType\CodeInfo $treatmentCode
     * @param string $description
     */
    public function __construct($questionPathType = null, $autoClosed = null, $answer = null, \StructType\CodeInfo $treatmentCode = null, $description = null)
    {
        $this
            ->setQuestionPathType($questionPathType)
            ->setAutoClosed($autoClosed)
            ->setAnswer($answer)
            ->setTreatmentCode($treatmentCode)
            ->setDescription($description);
    }
    /**
     * Get QuestionPathType value
     * @return int
     */
    public function getQuestionPathType()
    {
        return $this->QuestionPathType;
    }
    /**
     * Set QuestionPathType value
     * @param int $questionPathType
     * @return \StructType\QuestionPathInfo
     */
    public function setQuestionPathType($questionPathType = null)
    {
        // validation for constraint: int
        if (!is_null($questionPathType) && !is_numeric($questionPathType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($questionPathType)), __LINE__);
        }
        $this->QuestionPathType = $questionPathType;
        return $this;
    }
    /**
     * Get AutoClosed value
     * @return bool
     */
    public function getAutoClosed()
    {
        return $this->AutoClosed;
    }
    /**
     * Set AutoClosed value
     * @param bool $autoClosed
     * @return \StructType\QuestionPathInfo
     */
    public function setAutoClosed($autoClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoClosed) && !is_bool($autoClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($autoClosed)), __LINE__);
        }
        $this->AutoClosed = $autoClosed;
        return $this;
    }
    /**
     * Get Answer value
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->Answer;
    }
    /**
     * Set Answer value
     * @param string $answer
     * @return \StructType\QuestionPathInfo
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: string
        if (!is_null($answer) && !is_string($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($answer)), __LINE__);
        }
        $this->Answer = $answer;
        return $this;
    }
    /**
     * Get TreatmentCode value
     * @return \StructType\CodeInfo|null
     */
    public function getTreatmentCode()
    {
        return $this->TreatmentCode;
    }
    /**
     * Set TreatmentCode value
     * @param \StructType\CodeInfo $treatmentCode
     * @return \StructType\QuestionPathInfo
     */
    public function setTreatmentCode(\StructType\CodeInfo $treatmentCode = null)
    {
        $this->TreatmentCode = $treatmentCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\QuestionPathInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuestionPathInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
