<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductItemResult_V3 StructType
 * @subpackage Structs
 */
class ProductItemResult_V3 extends ProductItemResult_V2
{
    /**
     * The CheckoffType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CheckoffType;
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ProductType;
    /**
     * Constructor method for ProductItemResult_V3
     * @uses ProductItemResult_V3::setCheckoffType()
     * @uses ProductItemResult_V3::setProductType()
     * @param string $checkoffType
     * @param int $productType
     */
    public function __construct($checkoffType = null, $productType = null)
    {
        $this
            ->setCheckoffType($checkoffType)
            ->setProductType($productType);
    }
    /**
     * Get CheckoffType value
     * @return string
     */
    public function getCheckoffType()
    {
        return $this->CheckoffType;
    }
    /**
     * Set CheckoffType value
     * @uses \EnumType\EnumCheckOffType::valueIsValid()
     * @uses \EnumType\EnumCheckOffType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $checkoffType
     * @return \StructType\ProductItemResult_V3
     */
    public function setCheckoffType($checkoffType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCheckOffType::valueIsValid($checkoffType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $checkoffType, implode(', ', \EnumType\EnumCheckOffType::getValidValues())), __LINE__);
        }
        $this->CheckoffType = $checkoffType;
        return $this;
    }
    /**
     * Get ProductType value
     * @return int
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param int $productType
     * @return \StructType\ProductItemResult_V3
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: int
        if (!is_null($productType) && !is_numeric($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductItemResult_V3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
