<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product StructType
 * @subpackage Structs
 */
abstract class Product extends AbstractStructBase
{
    /**
     * The OrderSeq
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderSeq;
    /**
     * The CustomNr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomNr;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductID;
    /**
     * The DriverDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverDisplay;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The References
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReferenceProduct
     */
    public $References;
    /**
     * Constructor method for Product
     * @uses Product::setOrderSeq()
     * @uses Product::setCustomNr()
     * @uses Product::setProductID()
     * @uses Product::setDriverDisplay()
     * @uses Product::setComment()
     * @uses Product::setReferences()
     * @param int $orderSeq
     * @param int $customNr
     * @param string $productID
     * @param string $driverDisplay
     * @param string $comment
     * @param \StructType\ReferenceProduct $references
     */
    public function __construct($orderSeq = null, $customNr = null, $productID = null, $driverDisplay = null, $comment = null, \StructType\ReferenceProduct $references = null)
    {
        $this
            ->setOrderSeq($orderSeq)
            ->setCustomNr($customNr)
            ->setProductID($productID)
            ->setDriverDisplay($driverDisplay)
            ->setComment($comment)
            ->setReferences($references);
    }
    /**
     * Get OrderSeq value
     * @return int
     */
    public function getOrderSeq()
    {
        return $this->OrderSeq;
    }
    /**
     * Set OrderSeq value
     * @param int $orderSeq
     * @return \StructType\Product
     */
    public function setOrderSeq($orderSeq = null)
    {
        // validation for constraint: int
        if (!is_null($orderSeq) && !is_numeric($orderSeq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderSeq)), __LINE__);
        }
        $this->OrderSeq = $orderSeq;
        return $this;
    }
    /**
     * Get CustomNr value
     * @return int
     */
    public function getCustomNr()
    {
        return $this->CustomNr;
    }
    /**
     * Set CustomNr value
     * @param int $customNr
     * @return \StructType\Product
     */
    public function setCustomNr($customNr = null)
    {
        // validation for constraint: int
        if (!is_null($customNr) && !is_numeric($customNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customNr)), __LINE__);
        }
        $this->CustomNr = $customNr;
        return $this;
    }
    /**
     * Get ProductID value
     * @return string|null
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param string $productID
     * @return \StructType\Product
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: string
        if (!is_null($productID) && !is_string($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get DriverDisplay value
     * @return string|null
     */
    public function getDriverDisplay()
    {
        return $this->DriverDisplay;
    }
    /**
     * Set DriverDisplay value
     * @param string $driverDisplay
     * @return \StructType\Product
     */
    public function setDriverDisplay($driverDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($driverDisplay) && !is_string($driverDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverDisplay)), __LINE__);
        }
        $this->DriverDisplay = $driverDisplay;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Product
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get References value
     * @return \StructType\ReferenceProduct|null
     */
    public function getReferences()
    {
        return $this->References;
    }
    /**
     * Set References value
     * @param \StructType\ReferenceProduct $references
     * @return \StructType\Product
     */
    public function setReferences(\StructType\ReferenceProduct $references = null)
    {
        $this->References = $references;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Product
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
