<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionSelection_V4 StructType
 * @subpackage Structs
 */
class PositionSelection_V4 extends AbstractStructBase
{
    /**
     * The DataSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataSource;
    /**
     * The Drivers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The Vehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The Trailers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Trailers;
    /**
     * The DateTimeRangeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PeriodSelectionWithDateType
     */
    public $DateTimeRangeSelection;
    /**
     * The SelectionFromToday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeAndIdSelection
     */
    public $SelectionFromToday;
    /**
     * Constructor method for PositionSelection_V4
     * @uses PositionSelection_V4::setDataSource()
     * @uses PositionSelection_V4::setDrivers()
     * @uses PositionSelection_V4::setVehicles()
     * @uses PositionSelection_V4::setTrailers()
     * @uses PositionSelection_V4::setDateTimeRangeSelection()
     * @uses PositionSelection_V4::setSelectionFromToday()
     * @param string $dataSource
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @param \StructType\PeriodSelectionWithDateType $dateTimeRangeSelection
     * @param \StructType\DateTimeAndIdSelection $selectionFromToday
     */
    public function __construct($dataSource = null, \ArrayType\ArrayOfIdentifier $drivers = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \ArrayType\ArrayOfIdentifierVehicle $trailers = null, \StructType\PeriodSelectionWithDateType $dateTimeRangeSelection = null, \StructType\DateTimeAndIdSelection $selectionFromToday = null)
    {
        $this
            ->setDataSource($dataSource)
            ->setDrivers($drivers)
            ->setVehicles($vehicles)
            ->setTrailers($trailers)
            ->setDateTimeRangeSelection($dateTimeRangeSelection)
            ->setSelectionFromToday($selectionFromToday);
    }
    /**
     * Get DataSource value
     * @return string
     */
    public function getDataSource()
    {
        return $this->DataSource;
    }
    /**
     * Set DataSource value
     * @uses \EnumType\PositionDataSource::valueIsValid()
     * @uses \EnumType\PositionDataSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataSource
     * @return \StructType\PositionSelection_V4
     */
    public function setDataSource($dataSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PositionDataSource::valueIsValid($dataSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dataSource, implode(', ', \EnumType\PositionDataSource::getValidValues())), __LINE__);
        }
        $this->DataSource = $dataSource;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\PositionSelection_V4
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\PositionSelection_V4
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Trailers value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getTrailers()
    {
        return $this->Trailers;
    }
    /**
     * Set Trailers value
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @return \StructType\PositionSelection_V4
     */
    public function setTrailers(\ArrayType\ArrayOfIdentifierVehicle $trailers = null)
    {
        $this->Trailers = $trailers;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\PeriodSelectionWithDateType|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\PeriodSelectionWithDateType $dateTimeRangeSelection
     * @return \StructType\PositionSelection_V4
     */
    public function setDateTimeRangeSelection(\StructType\PeriodSelectionWithDateType $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
    /**
     * Get SelectionFromToday value
     * @return \StructType\DateTimeAndIdSelection|null
     */
    public function getSelectionFromToday()
    {
        return $this->SelectionFromToday;
    }
    /**
     * Set SelectionFromToday value
     * @param \StructType\DateTimeAndIdSelection $selectionFromToday
     * @return \StructType\PositionSelection_V4
     */
    public function setSelectionFromToday(\StructType\DateTimeAndIdSelection $selectionFromToday = null)
    {
        $this->SelectionFromToday = $selectionFromToday;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PositionSelection_V4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
