<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionResult_V4 StructType
 * @subpackage Structs
 */
class PositionResult_V4 extends PositionResult_V3
{
    /**
     * The LocationSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LocationSource;
    /**
     * Constructor method for PositionResult_V4
     * @uses PositionResult_V4::setLocationSource()
     * @param string $locationSource
     */
    public function __construct($locationSource = null)
    {
        $this
            ->setLocationSource($locationSource);
    }
    /**
     * Get LocationSource value
     * @return string
     */
    public function getLocationSource()
    {
        return $this->LocationSource;
    }
    /**
     * Set LocationSource value
     * @uses \EnumType\EnumPositionSource::valueIsValid()
     * @uses \EnumType\EnumPositionSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locationSource
     * @return \StructType\PositionResult_V4
     */
    public function setLocationSource($locationSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPositionSource::valueIsValid($locationSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $locationSource, implode(', ', \EnumType\EnumPositionSource::getValidValues())), __LINE__);
        }
        $this->LocationSource = $locationSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PositionResult_V4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
