<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionRangeSelection StructType
 * @subpackage Structs
 */
class PositionRangeSelection extends AbstractStructBase
{
    /**
     * The KmsAround
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $KmsAround;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StreetInfo
     */
    public $Address;
    /**
     * Constructor method for PositionRangeSelection
     * @uses PositionRangeSelection::setKmsAround()
     * @uses PositionRangeSelection::setPosition()
     * @uses PositionRangeSelection::setAddress()
     * @param float $kmsAround
     * @param \StructType\Position $position
     * @param \StructType\StreetInfo $address
     */
    public function __construct($kmsAround = null, \StructType\Position $position = null, \StructType\StreetInfo $address = null)
    {
        $this
            ->setKmsAround($kmsAround)
            ->setPosition($position)
            ->setAddress($address);
    }
    /**
     * Get KmsAround value
     * @return float
     */
    public function getKmsAround()
    {
        return $this->KmsAround;
    }
    /**
     * Set KmsAround value
     * @param float $kmsAround
     * @return \StructType\PositionRangeSelection
     */
    public function setKmsAround($kmsAround = null)
    {
        $this->KmsAround = $kmsAround;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\PositionRangeSelection
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\StreetInfo|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\StreetInfo $address
     * @return \StructType\PositionRangeSelection
     */
    public function setAddress(\StructType\StreetInfo $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PositionRangeSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
