<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionArea StructType
 * @subpackage Structs
 */
class PositionArea extends Position
{
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Radius;
    /**
     * Constructor method for PositionArea
     * @uses PositionArea::setRadius()
     * @param int $radius
     */
    public function __construct($radius = null)
    {
        $this
            ->setRadius($radius);
    }
    /**
     * Get Radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param int $radius
     * @return \StructType\PositionArea
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !is_numeric($radius)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PositionArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
