<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanningHistoricalSelection StructType
 * @subpackage Structs
 */
class PlanningHistoricalSelection extends AbstractStructBase
{
    /**
     * The SelectionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SelectionType;
    /**
     * The DateTimeSelectionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTimeSelectionType;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * The DateTimeRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRange;
    /**
     * Constructor method for PlanningHistoricalSelection
     * @uses PlanningHistoricalSelection::setSelectionType()
     * @uses PlanningHistoricalSelection::setDateTimeSelectionType()
     * @uses PlanningHistoricalSelection::setDriver()
     * @uses PlanningHistoricalSelection::setVehicle()
     * @uses PlanningHistoricalSelection::setDateTimeRange()
     * @param string $selectionType
     * @param string $dateTimeSelectionType
     * @param \StructType\Identifier $driver
     * @param \StructType\IdentifierVehicle $vehicle
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     */
    public function __construct($selectionType = null, $dateTimeSelectionType = null, \StructType\Identifier $driver = null, \StructType\IdentifierVehicle $vehicle = null, \StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this
            ->setSelectionType($selectionType)
            ->setDateTimeSelectionType($dateTimeSelectionType)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setDateTimeRange($dateTimeRange);
    }
    /**
     * Get SelectionType value
     * @return string
     */
    public function getSelectionType()
    {
        return $this->SelectionType;
    }
    /**
     * Set SelectionType value
     * @uses \EnumType\EnumPlanningSelectionHistoricalType::valueIsValid()
     * @uses \EnumType\EnumPlanningSelectionHistoricalType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionType
     * @return \StructType\PlanningHistoricalSelection
     */
    public function setSelectionType($selectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningSelectionHistoricalType::valueIsValid($selectionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $selectionType, implode(', ', \EnumType\EnumPlanningSelectionHistoricalType::getValidValues())), __LINE__);
        }
        $this->SelectionType = $selectionType;
        return $this;
    }
    /**
     * Get DateTimeSelectionType value
     * @return string
     */
    public function getDateTimeSelectionType()
    {
        return $this->DateTimeSelectionType;
    }
    /**
     * Set DateTimeSelectionType value
     * @uses \EnumType\EnumPlanningSelectionDateTime::valueIsValid()
     * @uses \EnumType\EnumPlanningSelectionDateTime::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateTimeSelectionType
     * @return \StructType\PlanningHistoricalSelection
     */
    public function setDateTimeSelectionType($dateTimeSelectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningSelectionDateTime::valueIsValid($dateTimeSelectionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dateTimeSelectionType, implode(', ', \EnumType\EnumPlanningSelectionDateTime::getValidValues())), __LINE__);
        }
        $this->DateTimeSelectionType = $dateTimeSelectionType;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\Identifier|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\Identifier $driver
     * @return \StructType\PlanningHistoricalSelection
     */
    public function setDriver(\StructType\Identifier $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\PlanningHistoricalSelection
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get DateTimeRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRange()
    {
        return $this->DateTimeRange;
    }
    /**
     * Set DateTimeRange value
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @return \StructType\PlanningHistoricalSelection
     */
    public function setDateTimeRange(\StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this->DateTimeRange = $dateTimeRange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlanningHistoricalSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
