<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceResultInsert StructType
 * @subpackage Structs
 */
class PlaceResultInsert extends AbstractStructBase
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Action;
    /**
     * The PlaceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceID;
    /**
     * The Jobs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJobResultInsert
     */
    public $Jobs;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductResultInsert
     */
    public $Products;
    /**
     * Constructor method for PlaceResultInsert
     * @uses PlaceResultInsert::setAction()
     * @uses PlaceResultInsert::setPlaceID()
     * @uses PlaceResultInsert::setJobs()
     * @uses PlaceResultInsert::setProducts()
     * @param string $action
     * @param string $placeID
     * @param \ArrayType\ArrayOfJobResultInsert $jobs
     * @param \ArrayType\ArrayOfProductResultInsert $products
     */
    public function __construct($action = null, $placeID = null, \ArrayType\ArrayOfJobResultInsert $jobs = null, \ArrayType\ArrayOfProductResultInsert $products = null)
    {
        $this
            ->setAction($action)
            ->setPlaceID($placeID)
            ->setJobs($jobs)
            ->setProducts($products);
    }
    /**
     * Get Action value
     * @return string
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\EnumPlanningActionType::valueIsValid()
     * @uses \EnumType\EnumPlanningActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\PlaceResultInsert
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningActionType::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\EnumPlanningActionType::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get PlaceID value
     * @return string|null
     */
    public function getPlaceID()
    {
        return $this->PlaceID;
    }
    /**
     * Set PlaceID value
     * @param string $placeID
     * @return \StructType\PlaceResultInsert
     */
    public function setPlaceID($placeID = null)
    {
        // validation for constraint: string
        if (!is_null($placeID) && !is_string($placeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeID)), __LINE__);
        }
        $this->PlaceID = $placeID;
        return $this;
    }
    /**
     * Get Jobs value
     * @return \ArrayType\ArrayOfJobResultInsert|null
     */
    public function getJobs()
    {
        return $this->Jobs;
    }
    /**
     * Set Jobs value
     * @param \ArrayType\ArrayOfJobResultInsert $jobs
     * @return \StructType\PlaceResultInsert
     */
    public function setJobs(\ArrayType\ArrayOfJobResultInsert $jobs = null)
    {
        $this->Jobs = $jobs;
        return $this;
    }
    /**
     * Get Products value
     * @return \ArrayType\ArrayOfProductResultInsert|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \ArrayType\ArrayOfProductResultInsert $products
     * @return \StructType\PlaceResultInsert
     */
    public function setProducts(\ArrayType\ArrayOfProductResultInsert $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceResultInsert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
