<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceItemResult_v2 StructType
 * @subpackage Structs
 */
class PlaceItemResult_v2 extends PlaceItemResult
{
    /**
     * The TransicsPlaceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsPlaceID;
    /**
     * The PlaceCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceCode;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The ViaRoute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ViaRouteItemResult
     */
    public $ViaRoute;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerResult
     */
    public $Customer;
    /**
     * The Shipper
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShipperResult
     */
    public $Shipper;
    /**
     * Constructor method for PlaceItemResult_v2
     * @uses PlaceItemResult_v2::setTransicsPlaceID()
     * @uses PlaceItemResult_v2::setPlaceCode()
     * @uses PlaceItemResult_v2::setPosition()
     * @uses PlaceItemResult_v2::setViaRoute()
     * @uses PlaceItemResult_v2::setCustomer()
     * @uses PlaceItemResult_v2::setShipper()
     * @param int $transicsPlaceID
     * @param string $placeCode
     * @param \StructType\Position $position
     * @param \StructType\ViaRouteItemResult $viaRoute
     * @param \StructType\CustomerResult $customer
     * @param \StructType\ShipperResult $shipper
     */
    public function __construct($transicsPlaceID = null, $placeCode = null, \StructType\Position $position = null, \StructType\ViaRouteItemResult $viaRoute = null, \StructType\CustomerResult $customer = null, \StructType\ShipperResult $shipper = null)
    {
        $this
            ->setTransicsPlaceID($transicsPlaceID)
            ->setPlaceCode($placeCode)
            ->setPosition($position)
            ->setViaRoute($viaRoute)
            ->setCustomer($customer)
            ->setShipper($shipper);
    }
    /**
     * Get TransicsPlaceID value
     * @return int
     */
    public function getTransicsPlaceID()
    {
        return $this->TransicsPlaceID;
    }
    /**
     * Set TransicsPlaceID value
     * @param int $transicsPlaceID
     * @return \StructType\PlaceItemResult_v2
     */
    public function setTransicsPlaceID($transicsPlaceID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsPlaceID) && !is_numeric($transicsPlaceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsPlaceID)), __LINE__);
        }
        $this->TransicsPlaceID = $transicsPlaceID;
        return $this;
    }
    /**
     * Get PlaceCode value
     * @return string|null
     */
    public function getPlaceCode()
    {
        return $this->PlaceCode;
    }
    /**
     * Set PlaceCode value
     * @param string $placeCode
     * @return \StructType\PlaceItemResult_v2
     */
    public function setPlaceCode($placeCode = null)
    {
        // validation for constraint: string
        if (!is_null($placeCode) && !is_string($placeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeCode)), __LINE__);
        }
        $this->PlaceCode = $placeCode;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\PlaceItemResult_v2
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get ViaRoute value
     * @return \StructType\ViaRouteItemResult|null
     */
    public function getViaRoute()
    {
        return $this->ViaRoute;
    }
    /**
     * Set ViaRoute value
     * @param \StructType\ViaRouteItemResult $viaRoute
     * @return \StructType\PlaceItemResult_v2
     */
    public function setViaRoute(\StructType\ViaRouteItemResult $viaRoute = null)
    {
        $this->ViaRoute = $viaRoute;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerResult|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerResult $customer
     * @return \StructType\PlaceItemResult_v2
     */
    public function setCustomer(\StructType\CustomerResult $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \StructType\ShipperResult|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \StructType\ShipperResult $shipper
     * @return \StructType\PlaceItemResult_v2
     */
    public function setShipper(\StructType\ShipperResult $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceItemResult_v2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
