<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceItemResult_V6 StructType
 * @subpackage Structs
 */
class PlaceItemResult_V6 extends Place_V2
{
    /**
     * The SynchronizationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The SynchronizationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SynchronizationId;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The CancelStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CancelStatus;
    /**
     * The TransicsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsID;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Author
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Author;
    /**
     * The References
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfReferenceItem
     */
    public $References;
    /**
     * The PlanningConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningConfig
     */
    public $PlanningConfig;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The ViaRoute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ViaRouteItemResult
     */
    public $ViaRoute;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerResult_V2
     */
    public $Customer;
    /**
     * Constructor method for PlaceItemResult_V6
     * @uses PlaceItemResult_V6::setSynchronizationDate()
     * @uses PlaceItemResult_V6::setSynchronizationId()
     * @uses PlaceItemResult_V6::setStartDate()
     * @uses PlaceItemResult_V6::setEndDate()
     * @uses PlaceItemResult_V6::setStatus()
     * @uses PlaceItemResult_V6::setCancelStatus()
     * @uses PlaceItemResult_V6::setTransicsID()
     * @uses PlaceItemResult_V6::setDriver()
     * @uses PlaceItemResult_V6::setVehicle()
     * @uses PlaceItemResult_V6::setAuthor()
     * @uses PlaceItemResult_V6::setReferences()
     * @uses PlaceItemResult_V6::setPlanningConfig()
     * @uses PlaceItemResult_V6::setPosition()
     * @uses PlaceItemResult_V6::setViaRoute()
     * @uses PlaceItemResult_V6::setCustomer()
     * @param string $synchronizationDate
     * @param int $synchronizationId
     * @param string $startDate
     * @param string $endDate
     * @param string $status
     * @param string $cancelStatus
     * @param int $transicsID
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param string $author
     * @param \ArrayType\ArrayOfReferenceItem $references
     * @param \StructType\PlanningConfig $planningConfig
     * @param \StructType\Position $position
     * @param \StructType\ViaRouteItemResult $viaRoute
     * @param \StructType\CustomerResult_V2 $customer
     */
    public function __construct($synchronizationDate = null, $synchronizationId = null, $startDate = null, $endDate = null, $status = null, $cancelStatus = null, $transicsID = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, $author = null, \ArrayType\ArrayOfReferenceItem $references = null, \StructType\PlanningConfig $planningConfig = null, \StructType\Position $position = null, \StructType\ViaRouteItemResult $viaRoute = null, \StructType\CustomerResult_V2 $customer = null)
    {
        $this
            ->setSynchronizationDate($synchronizationDate)
            ->setSynchronizationId($synchronizationId)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setStatus($status)
            ->setCancelStatus($cancelStatus)
            ->setTransicsID($transicsID)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setAuthor($author)
            ->setReferences($references)
            ->setPlanningConfig($planningConfig)
            ->setPosition($position)
            ->setViaRoute($viaRoute)
            ->setCustomer($customer);
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\PlaceItemResult_V6
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get SynchronizationId value
     * @return int
     */
    public function getSynchronizationId()
    {
        return $this->SynchronizationId;
    }
    /**
     * Set SynchronizationId value
     * @param int $synchronizationId
     * @return \StructType\PlaceItemResult_V6
     */
    public function setSynchronizationId($synchronizationId = null)
    {
        // validation for constraint: int
        if (!is_null($synchronizationId) && !is_numeric($synchronizationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($synchronizationId)), __LINE__);
        }
        $this->SynchronizationId = $synchronizationId;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\PlaceItemResult_V6
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\PlaceItemResult_V6
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumTransferStatus::valueIsValid()
     * @uses \EnumType\EnumTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\PlaceItemResult_V6
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTransferStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\EnumTransferStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CancelStatus value
     * @return string
     */
    public function getCancelStatus()
    {
        return $this->CancelStatus;
    }
    /**
     * Set CancelStatus value
     * @uses \EnumType\EnumCancelStatus::valueIsValid()
     * @uses \EnumType\EnumCancelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelStatus
     * @return \StructType\PlaceItemResult_V6
     */
    public function setCancelStatus($cancelStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCancelStatus::valueIsValid($cancelStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cancelStatus, implode(', ', \EnumType\EnumCancelStatus::getValidValues())), __LINE__);
        }
        $this->CancelStatus = $cancelStatus;
        return $this;
    }
    /**
     * Get TransicsID value
     * @return int
     */
    public function getTransicsID()
    {
        return $this->TransicsID;
    }
    /**
     * Set TransicsID value
     * @param int $transicsID
     * @return \StructType\PlaceItemResult_V6
     */
    public function setTransicsID($transicsID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsID) && !is_numeric($transicsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsID)), __LINE__);
        }
        $this->TransicsID = $transicsID;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\PlaceItemResult_V6
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\PlaceItemResult_V6
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\PlaceItemResult_V6
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get References value
     * @return \ArrayType\ArrayOfReferenceItem|null
     */
    public function getReferences()
    {
        return $this->References;
    }
    /**
     * Set References value
     * @param \ArrayType\ArrayOfReferenceItem $references
     * @return \StructType\PlaceItemResult_V6
     */
    public function setReferences(\ArrayType\ArrayOfReferenceItem $references = null)
    {
        $this->References = $references;
        return $this;
    }
    /**
     * Get PlanningConfig value
     * @return \StructType\PlanningConfig|null
     */
    public function getPlanningConfig()
    {
        return $this->PlanningConfig;
    }
    /**
     * Set PlanningConfig value
     * @param \StructType\PlanningConfig $planningConfig
     * @return \StructType\PlaceItemResult_V6
     */
    public function setPlanningConfig(\StructType\PlanningConfig $planningConfig = null)
    {
        $this->PlanningConfig = $planningConfig;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\PlaceItemResult_V6
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get ViaRoute value
     * @return \StructType\ViaRouteItemResult|null
     */
    public function getViaRoute()
    {
        return $this->ViaRoute;
    }
    /**
     * Set ViaRoute value
     * @param \StructType\ViaRouteItemResult $viaRoute
     * @return \StructType\PlaceItemResult_V6
     */
    public function setViaRoute(\StructType\ViaRouteItemResult $viaRoute = null)
    {
        $this->ViaRoute = $viaRoute;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerResult_V2|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerResult_V2 $customer
     * @return \StructType\PlaceItemResult_V6
     */
    public function setCustomer(\StructType\CustomerResult_V2 $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceItemResult_V6
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
