<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceItemResult_V4 StructType
 * @subpackage Structs
 */
class PlaceItemResult_V4 extends PlaceItemResult_V3
{
    /**
     * The PlaceStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlaceStatus;
    /**
     * Constructor method for PlaceItemResult_V4
     * @uses PlaceItemResult_V4::setPlaceStatus()
     * @param string $placeStatus
     */
    public function __construct($placeStatus = null)
    {
        $this
            ->setPlaceStatus($placeStatus);
    }
    /**
     * Get PlaceStatus value
     * @return string
     */
    public function getPlaceStatus()
    {
        return $this->PlaceStatus;
    }
    /**
     * Set PlaceStatus value
     * @uses \EnumType\EnumPlaceStatus::valueIsValid()
     * @uses \EnumType\EnumPlaceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $placeStatus
     * @return \StructType\PlaceItemResult_V4
     */
    public function setPlaceStatus($placeStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlaceStatus::valueIsValid($placeStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $placeStatus, implode(', ', \EnumType\EnumPlaceStatus::getValidValues())), __LINE__);
        }
        $this->PlaceStatus = $placeStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceItemResult_V4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
