<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceInterfaceResult_v3 StructType
 * @subpackage Structs
 */
class PlaceInterfaceResult_v3 extends Place
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ModificationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The ModificationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ModificationNumber;
    /**
     * The Export
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Export;
    /**
     * The ReadDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReadDateTime;
    /**
     * The AlarmDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AlarmDateTime;
    /**
     * The ExternalSynchStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExternalSynchStatus;
    /**
     * The CreatedByDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CreatedByDriver;
    /**
     * The CancelStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CancelStatus;
    /**
     * The ModificationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ModificationID;
    /**
     * The Author
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Author;
    /**
     * The SessionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SessionID;
    /**
     * The DriverInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverInfo;
    /**
     * The Format
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Format;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The Geofencing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeofencingResult
     */
    public $Geofencing;
    /**
     * The Consultations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfConsultation_V2
     */
    public $Consultations;
    /**
     * The Anomalies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnomaly
     */
    public $Anomalies;
    /**
     * The PalletInfos
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraInfo
     */
    public $PalletInfos;
    /**
     * The ExtraInfos
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraInfo
     */
    public $ExtraInfos;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfComment
     */
    public $Comments;
    /**
     * The Transfer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Transfer
     */
    public $Transfer;
    /**
     * The Documents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocument
     */
    public $Documents;
    /**
     * The Jobs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJobInterfaceResult_v3
     */
    public $Jobs;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductInterfaceResult_v3
     */
    public $Products;
    /**
     * The TachoActivities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTachoActivity
     */
    public $TachoActivities;
    /**
     * The AddressDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressDescription;
    /**
     * The ViaRoute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ViaRouteItemResult
     */
    public $ViaRoute;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Customer
     */
    public $Customer;
    /**
     * The Shipper
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Shipper
     */
    public $Shipper;
    /**
     * Constructor method for PlaceInterfaceResult_v3
     * @uses PlaceInterfaceResult_v3::setStatus()
     * @uses PlaceInterfaceResult_v3::setStartDate()
     * @uses PlaceInterfaceResult_v3::setEndDate()
     * @uses PlaceInterfaceResult_v3::setModificationDate()
     * @uses PlaceInterfaceResult_v3::setModificationNumber()
     * @uses PlaceInterfaceResult_v3::setExport()
     * @uses PlaceInterfaceResult_v3::setReadDateTime()
     * @uses PlaceInterfaceResult_v3::setAlarmDateTime()
     * @uses PlaceInterfaceResult_v3::setExternalSynchStatus()
     * @uses PlaceInterfaceResult_v3::setCreatedByDriver()
     * @uses PlaceInterfaceResult_v3::setCancelStatus()
     * @uses PlaceInterfaceResult_v3::setModificationID()
     * @uses PlaceInterfaceResult_v3::setAuthor()
     * @uses PlaceInterfaceResult_v3::setSessionID()
     * @uses PlaceInterfaceResult_v3::setDriverInfo()
     * @uses PlaceInterfaceResult_v3::setFormat()
     * @uses PlaceInterfaceResult_v3::setPosition()
     * @uses PlaceInterfaceResult_v3::setGeofencing()
     * @uses PlaceInterfaceResult_v3::setConsultations()
     * @uses PlaceInterfaceResult_v3::setAnomalies()
     * @uses PlaceInterfaceResult_v3::setPalletInfos()
     * @uses PlaceInterfaceResult_v3::setExtraInfos()
     * @uses PlaceInterfaceResult_v3::setComments()
     * @uses PlaceInterfaceResult_v3::setTransfer()
     * @uses PlaceInterfaceResult_v3::setDocuments()
     * @uses PlaceInterfaceResult_v3::setJobs()
     * @uses PlaceInterfaceResult_v3::setProducts()
     * @uses PlaceInterfaceResult_v3::setTachoActivities()
     * @uses PlaceInterfaceResult_v3::setAddressDescription()
     * @uses PlaceInterfaceResult_v3::setViaRoute()
     * @uses PlaceInterfaceResult_v3::setCustomer()
     * @uses PlaceInterfaceResult_v3::setShipper()
     * @param string $status
     * @param string $startDate
     * @param string $endDate
     * @param string $modificationDate
     * @param int $modificationNumber
     * @param int $export
     * @param string $readDateTime
     * @param string $alarmDateTime
     * @param string $externalSynchStatus
     * @param bool $createdByDriver
     * @param string $cancelStatus
     * @param int $modificationID
     * @param string $author
     * @param string $sessionID
     * @param string $driverInfo
     * @param string $format
     * @param \StructType\Position $position
     * @param \StructType\GeofencingResult $geofencing
     * @param \ArrayType\ArrayOfConsultation_V2 $consultations
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @param \ArrayType\ArrayOfExtraInfo $palletInfos
     * @param \ArrayType\ArrayOfExtraInfo $extraInfos
     * @param \ArrayType\ArrayOfComment $comments
     * @param \StructType\Transfer $transfer
     * @param \ArrayType\ArrayOfDocument $documents
     * @param \ArrayType\ArrayOfJobInterfaceResult_v3 $jobs
     * @param \ArrayType\ArrayOfProductInterfaceResult_v3 $products
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @param string $addressDescription
     * @param \StructType\ViaRouteItemResult $viaRoute
     * @param \StructType\Customer $customer
     * @param \StructType\Shipper $shipper
     */
    public function __construct($status = null, $startDate = null, $endDate = null, $modificationDate = null, $modificationNumber = null, $export = null, $readDateTime = null, $alarmDateTime = null, $externalSynchStatus = null, $createdByDriver = null, $cancelStatus = null, $modificationID = null, $author = null, $sessionID = null, $driverInfo = null, $format = null, \StructType\Position $position = null, \StructType\GeofencingResult $geofencing = null, \ArrayType\ArrayOfConsultation_V2 $consultations = null, \ArrayType\ArrayOfAnomaly $anomalies = null, \ArrayType\ArrayOfExtraInfo $palletInfos = null, \ArrayType\ArrayOfExtraInfo $extraInfos = null, \ArrayType\ArrayOfComment $comments = null, \StructType\Transfer $transfer = null, \ArrayType\ArrayOfDocument $documents = null, \ArrayType\ArrayOfJobInterfaceResult_v3 $jobs = null, \ArrayType\ArrayOfProductInterfaceResult_v3 $products = null, \ArrayType\ArrayOfTachoActivity $tachoActivities = null, $addressDescription = null, \StructType\ViaRouteItemResult $viaRoute = null, \StructType\Customer $customer = null, \StructType\Shipper $shipper = null)
    {
        $this
            ->setStatus($status)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setModificationDate($modificationDate)
            ->setModificationNumber($modificationNumber)
            ->setExport($export)
            ->setReadDateTime($readDateTime)
            ->setAlarmDateTime($alarmDateTime)
            ->setExternalSynchStatus($externalSynchStatus)
            ->setCreatedByDriver($createdByDriver)
            ->setCancelStatus($cancelStatus)
            ->setModificationID($modificationID)
            ->setAuthor($author)
            ->setSessionID($sessionID)
            ->setDriverInfo($driverInfo)
            ->setFormat($format)
            ->setPosition($position)
            ->setGeofencing($geofencing)
            ->setConsultations($consultations)
            ->setAnomalies($anomalies)
            ->setPalletInfos($palletInfos)
            ->setExtraInfos($extraInfos)
            ->setComments($comments)
            ->setTransfer($transfer)
            ->setDocuments($documents)
            ->setJobs($jobs)
            ->setProducts($products)
            ->setTachoActivities($tachoActivities)
            ->setAddressDescription($addressDescription)
            ->setViaRoute($viaRoute)
            ->setCustomer($customer)
            ->setShipper($shipper);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumPlanningStatus::valueIsValid()
     * @uses \EnumType\EnumPlanningStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\EnumPlanningStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get ModificationNumber value
     * @return int
     */
    public function getModificationNumber()
    {
        return $this->ModificationNumber;
    }
    /**
     * Set ModificationNumber value
     * @param int $modificationNumber
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setModificationNumber($modificationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($modificationNumber) && !is_numeric($modificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($modificationNumber)), __LINE__);
        }
        $this->ModificationNumber = $modificationNumber;
        return $this;
    }
    /**
     * Get Export value
     * @return int
     */
    public function getExport()
    {
        return $this->Export;
    }
    /**
     * Set Export value
     * @param int $export
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setExport($export = null)
    {
        // validation for constraint: int
        if (!is_null($export) && !is_numeric($export)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($export)), __LINE__);
        }
        $this->Export = $export;
        return $this;
    }
    /**
     * Get ReadDateTime value
     * @return string
     */
    public function getReadDateTime()
    {
        return $this->ReadDateTime;
    }
    /**
     * Set ReadDateTime value
     * @param string $readDateTime
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setReadDateTime($readDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($readDateTime) && !is_string($readDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readDateTime)), __LINE__);
        }
        $this->ReadDateTime = $readDateTime;
        return $this;
    }
    /**
     * Get AlarmDateTime value
     * @return string
     */
    public function getAlarmDateTime()
    {
        return $this->AlarmDateTime;
    }
    /**
     * Set AlarmDateTime value
     * @param string $alarmDateTime
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setAlarmDateTime($alarmDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($alarmDateTime) && !is_string($alarmDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alarmDateTime)), __LINE__);
        }
        $this->AlarmDateTime = $alarmDateTime;
        return $this;
    }
    /**
     * Get ExternalSynchStatus value
     * @return string
     */
    public function getExternalSynchStatus()
    {
        return $this->ExternalSynchStatus;
    }
    /**
     * Set ExternalSynchStatus value
     * @uses \EnumType\EnumSynchronisationStatus::valueIsValid()
     * @uses \EnumType\EnumSynchronisationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $externalSynchStatus
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setExternalSynchStatus($externalSynchStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSynchronisationStatus::valueIsValid($externalSynchStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $externalSynchStatus, implode(', ', \EnumType\EnumSynchronisationStatus::getValidValues())), __LINE__);
        }
        $this->ExternalSynchStatus = $externalSynchStatus;
        return $this;
    }
    /**
     * Get CreatedByDriver value
     * @return bool
     */
    public function getCreatedByDriver()
    {
        return $this->CreatedByDriver;
    }
    /**
     * Set CreatedByDriver value
     * @param bool $createdByDriver
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setCreatedByDriver($createdByDriver = null)
    {
        // validation for constraint: boolean
        if (!is_null($createdByDriver) && !is_bool($createdByDriver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($createdByDriver)), __LINE__);
        }
        $this->CreatedByDriver = $createdByDriver;
        return $this;
    }
    /**
     * Get CancelStatus value
     * @return string
     */
    public function getCancelStatus()
    {
        return $this->CancelStatus;
    }
    /**
     * Set CancelStatus value
     * @uses \EnumType\EnumCancelStatus::valueIsValid()
     * @uses \EnumType\EnumCancelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelStatus
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setCancelStatus($cancelStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCancelStatus::valueIsValid($cancelStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cancelStatus, implode(', ', \EnumType\EnumCancelStatus::getValidValues())), __LINE__);
        }
        $this->CancelStatus = $cancelStatus;
        return $this;
    }
    /**
     * Get ModificationID value
     * @return int
     */
    public function getModificationID()
    {
        return $this->ModificationID;
    }
    /**
     * Set ModificationID value
     * @param int $modificationID
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setModificationID($modificationID = null)
    {
        // validation for constraint: int
        if (!is_null($modificationID) && !is_numeric($modificationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($modificationID)), __LINE__);
        }
        $this->ModificationID = $modificationID;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get SessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->SessionID;
    }
    /**
     * Set SessionID value
     * @param string $sessionID
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionID)), __LINE__);
        }
        $this->SessionID = $sessionID;
        return $this;
    }
    /**
     * Get DriverInfo value
     * @return string|null
     */
    public function getDriverInfo()
    {
        return $this->DriverInfo;
    }
    /**
     * Set DriverInfo value
     * @param string $driverInfo
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setDriverInfo($driverInfo = null)
    {
        // validation for constraint: string
        if (!is_null($driverInfo) && !is_string($driverInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverInfo)), __LINE__);
        }
        $this->DriverInfo = $driverInfo;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Geofencing value
     * @return \StructType\GeofencingResult|null
     */
    public function getGeofencing()
    {
        return $this->Geofencing;
    }
    /**
     * Set Geofencing value
     * @param \StructType\GeofencingResult $geofencing
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setGeofencing(\StructType\GeofencingResult $geofencing = null)
    {
        $this->Geofencing = $geofencing;
        return $this;
    }
    /**
     * Get Consultations value
     * @return \ArrayType\ArrayOfConsultation_V2|null
     */
    public function getConsultations()
    {
        return $this->Consultations;
    }
    /**
     * Set Consultations value
     * @param \ArrayType\ArrayOfConsultation_V2 $consultations
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setConsultations(\ArrayType\ArrayOfConsultation_V2 $consultations = null)
    {
        $this->Consultations = $consultations;
        return $this;
    }
    /**
     * Get Anomalies value
     * @return \ArrayType\ArrayOfAnomaly|null
     */
    public function getAnomalies()
    {
        return $this->Anomalies;
    }
    /**
     * Set Anomalies value
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setAnomalies(\ArrayType\ArrayOfAnomaly $anomalies = null)
    {
        $this->Anomalies = $anomalies;
        return $this;
    }
    /**
     * Get PalletInfos value
     * @return \ArrayType\ArrayOfExtraInfo|null
     */
    public function getPalletInfos()
    {
        return $this->PalletInfos;
    }
    /**
     * Set PalletInfos value
     * @param \ArrayType\ArrayOfExtraInfo $palletInfos
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setPalletInfos(\ArrayType\ArrayOfExtraInfo $palletInfos = null)
    {
        $this->PalletInfos = $palletInfos;
        return $this;
    }
    /**
     * Get ExtraInfos value
     * @return \ArrayType\ArrayOfExtraInfo|null
     */
    public function getExtraInfos()
    {
        return $this->ExtraInfos;
    }
    /**
     * Set ExtraInfos value
     * @param \ArrayType\ArrayOfExtraInfo $extraInfos
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setExtraInfos(\ArrayType\ArrayOfExtraInfo $extraInfos = null)
    {
        $this->ExtraInfos = $extraInfos;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfComment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfComment $comments
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setComments(\ArrayType\ArrayOfComment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Transfer value
     * @return \StructType\Transfer|null
     */
    public function getTransfer()
    {
        return $this->Transfer;
    }
    /**
     * Set Transfer value
     * @param \StructType\Transfer $transfer
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setTransfer(\StructType\Transfer $transfer = null)
    {
        $this->Transfer = $transfer;
        return $this;
    }
    /**
     * Get Documents value
     * @return \ArrayType\ArrayOfDocument|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * Set Documents value
     * @param \ArrayType\ArrayOfDocument $documents
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setDocuments(\ArrayType\ArrayOfDocument $documents = null)
    {
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Get Jobs value
     * @return \ArrayType\ArrayOfJobInterfaceResult_v3|null
     */
    public function getJobs()
    {
        return $this->Jobs;
    }
    /**
     * Set Jobs value
     * @param \ArrayType\ArrayOfJobInterfaceResult_v3 $jobs
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setJobs(\ArrayType\ArrayOfJobInterfaceResult_v3 $jobs = null)
    {
        $this->Jobs = $jobs;
        return $this;
    }
    /**
     * Get Products value
     * @return \ArrayType\ArrayOfProductInterfaceResult_v3|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \ArrayType\ArrayOfProductInterfaceResult_v3 $products
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setProducts(\ArrayType\ArrayOfProductInterfaceResult_v3 $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get TachoActivities value
     * @return \ArrayType\ArrayOfTachoActivity|null
     */
    public function getTachoActivities()
    {
        return $this->TachoActivities;
    }
    /**
     * Set TachoActivities value
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setTachoActivities(\ArrayType\ArrayOfTachoActivity $tachoActivities = null)
    {
        $this->TachoActivities = $tachoActivities;
        return $this;
    }
    /**
     * Get AddressDescription value
     * @return string|null
     */
    public function getAddressDescription()
    {
        return $this->AddressDescription;
    }
    /**
     * Set AddressDescription value
     * @param string $addressDescription
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setAddressDescription($addressDescription = null)
    {
        // validation for constraint: string
        if (!is_null($addressDescription) && !is_string($addressDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressDescription)), __LINE__);
        }
        $this->AddressDescription = $addressDescription;
        return $this;
    }
    /**
     * Get ViaRoute value
     * @return \StructType\ViaRouteItemResult|null
     */
    public function getViaRoute()
    {
        return $this->ViaRoute;
    }
    /**
     * Set ViaRoute value
     * @param \StructType\ViaRouteItemResult $viaRoute
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setViaRoute(\StructType\ViaRouteItemResult $viaRoute = null)
    {
        $this->ViaRoute = $viaRoute;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\Customer $customer
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \StructType\Shipper|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \StructType\Shipper $shipper
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public function setShipper(\StructType\Shipper $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceInterfaceResult_v3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
