<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceIdentifier StructType
 * @subpackage Structs
 */
class PlaceIdentifier extends AbstractStructBase
{
    /**
     * The TransicsPlaceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsPlaceID;
    /**
     * The PlaceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceID;
    /**
     * Constructor method for PlaceIdentifier
     * @uses PlaceIdentifier::setTransicsPlaceID()
     * @uses PlaceIdentifier::setPlaceID()
     * @param int $transicsPlaceID
     * @param string $placeID
     */
    public function __construct($transicsPlaceID = null, $placeID = null)
    {
        $this
            ->setTransicsPlaceID($transicsPlaceID)
            ->setPlaceID($placeID);
    }
    /**
     * Get TransicsPlaceID value
     * @return int
     */
    public function getTransicsPlaceID()
    {
        return $this->TransicsPlaceID;
    }
    /**
     * Set TransicsPlaceID value
     * @param int $transicsPlaceID
     * @return \StructType\PlaceIdentifier
     */
    public function setTransicsPlaceID($transicsPlaceID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsPlaceID) && !is_numeric($transicsPlaceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsPlaceID)), __LINE__);
        }
        $this->TransicsPlaceID = $transicsPlaceID;
        return $this;
    }
    /**
     * Get PlaceID value
     * @return string|null
     */
    public function getPlaceID()
    {
        return $this->PlaceID;
    }
    /**
     * Set PlaceID value
     * @param string $placeID
     * @return \StructType\PlaceIdentifier
     */
    public function setPlaceID($placeID = null)
    {
        // validation for constraint: string
        if (!is_null($placeID) && !is_string($placeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeID)), __LINE__);
        }
        $this->PlaceID = $placeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
