<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person_V5 StructType
 * @subpackage Structs
 */
abstract class Person_V5 extends AbstractStructBase
{
    /**
     * The SmartCardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SmartCardNumber;
    /**
     * The Inactive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Inactive;
    /**
     * The PersonId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonId;
    /**
     * The PersonExternalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonExternalCode;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Lastname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Lastname;
    /**
     * The Firstname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Firstname;
    /**
     * The Filter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filter;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Languages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonLanguages
     */
    public $Languages;
    /**
     * The LicenseInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonLicenseInfo
     */
    public $LicenseInfo;
    /**
     * The HRInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonHRInfo
     */
    public $HRInfo;
    /**
     * The ContactInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfacePersonContactInfo_V4
     */
    public $ContactInfo;
    /**
     * The Groups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonGroups
     */
    public $Groups;
    /**
     * Constructor method for Person_V5
     * @uses Person_V5::setSmartCardNumber()
     * @uses Person_V5::setInactive()
     * @uses Person_V5::setPersonId()
     * @uses Person_V5::setPersonExternalCode()
     * @uses Person_V5::setTitle()
     * @uses Person_V5::setLastname()
     * @uses Person_V5::setFirstname()
     * @uses Person_V5::setFilter()
     * @uses Person_V5::setDescription()
     * @uses Person_V5::setLanguages()
     * @uses Person_V5::setLicenseInfo()
     * @uses Person_V5::setHRInfo()
     * @uses Person_V5::setContactInfo()
     * @uses Person_V5::setGroups()
     * @param int $smartCardNumber
     * @param bool $inactive
     * @param string $personId
     * @param string $personExternalCode
     * @param string $title
     * @param string $lastname
     * @param string $firstname
     * @param string $filter
     * @param string $description
     * @param \StructType\PersonLanguages $languages
     * @param \StructType\PersonLicenseInfo $licenseInfo
     * @param \StructType\PersonHRInfo $hRInfo
     * @param \StructType\InterfacePersonContactInfo_V4 $contactInfo
     * @param \StructType\PersonGroups $groups
     */
    public function __construct($smartCardNumber = null, $inactive = null, $personId = null, $personExternalCode = null, $title = null, $lastname = null, $firstname = null, $filter = null, $description = null, \StructType\PersonLanguages $languages = null, \StructType\PersonLicenseInfo $licenseInfo = null, \StructType\PersonHRInfo $hRInfo = null, \StructType\InterfacePersonContactInfo_V4 $contactInfo = null, \StructType\PersonGroups $groups = null)
    {
        $this
            ->setSmartCardNumber($smartCardNumber)
            ->setInactive($inactive)
            ->setPersonId($personId)
            ->setPersonExternalCode($personExternalCode)
            ->setTitle($title)
            ->setLastname($lastname)
            ->setFirstname($firstname)
            ->setFilter($filter)
            ->setDescription($description)
            ->setLanguages($languages)
            ->setLicenseInfo($licenseInfo)
            ->setHRInfo($hRInfo)
            ->setContactInfo($contactInfo)
            ->setGroups($groups);
    }
    /**
     * Get SmartCardNumber value
     * @return int
     */
    public function getSmartCardNumber()
    {
        return $this->SmartCardNumber;
    }
    /**
     * Set SmartCardNumber value
     * @param int $smartCardNumber
     * @return \StructType\Person_V5
     */
    public function setSmartCardNumber($smartCardNumber = null)
    {
        // validation for constraint: int
        if (!is_null($smartCardNumber) && !is_numeric($smartCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($smartCardNumber)), __LINE__);
        }
        $this->SmartCardNumber = $smartCardNumber;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Person_V5
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get PersonId value
     * @return string|null
     */
    public function getPersonId()
    {
        return $this->PersonId;
    }
    /**
     * Set PersonId value
     * @param string $personId
     * @return \StructType\Person_V5
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: string
        if (!is_null($personId) && !is_string($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personId)), __LINE__);
        }
        $this->PersonId = $personId;
        return $this;
    }
    /**
     * Get PersonExternalCode value
     * @return string|null
     */
    public function getPersonExternalCode()
    {
        return $this->PersonExternalCode;
    }
    /**
     * Set PersonExternalCode value
     * @param string $personExternalCode
     * @return \StructType\Person_V5
     */
    public function setPersonExternalCode($personExternalCode = null)
    {
        // validation for constraint: string
        if (!is_null($personExternalCode) && !is_string($personExternalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personExternalCode)), __LINE__);
        }
        $this->PersonExternalCode = $personExternalCode;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Person_V5
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->Lastname;
    }
    /**
     * Set Lastname value
     * @param string $lastname
     * @return \StructType\Person_V5
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastname)), __LINE__);
        }
        $this->Lastname = $lastname;
        return $this;
    }
    /**
     * Get Firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->Firstname;
    }
    /**
     * Set Firstname value
     * @param string $firstname
     * @return \StructType\Person_V5
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstname)), __LINE__);
        }
        $this->Firstname = $firstname;
        return $this;
    }
    /**
     * Get Filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param string $filter
     * @return \StructType\Person_V5
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filter)), __LINE__);
        }
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Person_V5
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Languages value
     * @return \StructType\PersonLanguages|null
     */
    public function getLanguages()
    {
        return $this->Languages;
    }
    /**
     * Set Languages value
     * @param \StructType\PersonLanguages $languages
     * @return \StructType\Person_V5
     */
    public function setLanguages(\StructType\PersonLanguages $languages = null)
    {
        $this->Languages = $languages;
        return $this;
    }
    /**
     * Get LicenseInfo value
     * @return \StructType\PersonLicenseInfo|null
     */
    public function getLicenseInfo()
    {
        return $this->LicenseInfo;
    }
    /**
     * Set LicenseInfo value
     * @param \StructType\PersonLicenseInfo $licenseInfo
     * @return \StructType\Person_V5
     */
    public function setLicenseInfo(\StructType\PersonLicenseInfo $licenseInfo = null)
    {
        $this->LicenseInfo = $licenseInfo;
        return $this;
    }
    /**
     * Get HRInfo value
     * @return \StructType\PersonHRInfo|null
     */
    public function getHRInfo()
    {
        return $this->HRInfo;
    }
    /**
     * Set HRInfo value
     * @param \StructType\PersonHRInfo $hRInfo
     * @return \StructType\Person_V5
     */
    public function setHRInfo(\StructType\PersonHRInfo $hRInfo = null)
    {
        $this->HRInfo = $hRInfo;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\InterfacePersonContactInfo_V4|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\InterfacePersonContactInfo_V4 $contactInfo
     * @return \StructType\Person_V5
     */
    public function setContactInfo(\StructType\InterfacePersonContactInfo_V4 $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get Groups value
     * @return \StructType\PersonGroups|null
     */
    public function getGroups()
    {
        return $this->Groups;
    }
    /**
     * Set Groups value
     * @param \StructType\PersonGroups $groups
     * @return \StructType\Person_V5
     */
    public function setGroups(\StructType\PersonGroups $groups = null)
    {
        $this->Groups = $groups;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Person_V5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
