<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonTechnicalInfo StructType
 * @subpackage Structs
 */
class PersonTechnicalInfo extends AbstractStructBase
{
    /**
     * The SexType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SexType;
    /**
     * The HasMedicalCertificate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $HasMedicalCertificate;
    /**
     * The MedicalCertificate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MedicalCertificate;
    /**
     * The CivilState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CivilState;
    /**
     * The DriverLicenseValid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DriverLicenseValid;
    /**
     * The Employed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Employed;
    /**
     * The Resigned
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Resigned;
    /**
     * The FuelPumpRead
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $FuelPumpRead;
    /**
     * The ADRCertificate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ADRCertificate;
    /**
     * The ADRCertificateValid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ADRCertificateValid;
    /**
     * The ApplyGeneralCardInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ApplyGeneralCardInformation;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The AntiTheftPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AntiTheftPassword;
    /**
     * The Pincode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Pincode;
    /**
     * The PensionNr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PensionNr;
    /**
     * The RijksregisterNr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RijksregisterNr;
    /**
     * The SyscardNr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SyscardNr;
    /**
     * The DriverLicense
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverLicense;
    /**
     * Constructor method for PersonTechnicalInfo
     * @uses PersonTechnicalInfo::setSexType()
     * @uses PersonTechnicalInfo::setHasMedicalCertificate()
     * @uses PersonTechnicalInfo::setMedicalCertificate()
     * @uses PersonTechnicalInfo::setCivilState()
     * @uses PersonTechnicalInfo::setDriverLicenseValid()
     * @uses PersonTechnicalInfo::setEmployed()
     * @uses PersonTechnicalInfo::setResigned()
     * @uses PersonTechnicalInfo::setFuelPumpRead()
     * @uses PersonTechnicalInfo::setADRCertificate()
     * @uses PersonTechnicalInfo::setADRCertificateValid()
     * @uses PersonTechnicalInfo::setApplyGeneralCardInformation()
     * @uses PersonTechnicalInfo::setPassword()
     * @uses PersonTechnicalInfo::setAntiTheftPassword()
     * @uses PersonTechnicalInfo::setPincode()
     * @uses PersonTechnicalInfo::setPensionNr()
     * @uses PersonTechnicalInfo::setRijksregisterNr()
     * @uses PersonTechnicalInfo::setSyscardNr()
     * @uses PersonTechnicalInfo::setDriverLicense()
     * @param string $sexType
     * @param bool $hasMedicalCertificate
     * @param string $medicalCertificate
     * @param string $civilState
     * @param string $driverLicenseValid
     * @param string $employed
     * @param string $resigned
     * @param bool $fuelPumpRead
     * @param bool $aDRCertificate
     * @param string $aDRCertificateValid
     * @param bool $applyGeneralCardInformation
     * @param string $password
     * @param string $antiTheftPassword
     * @param string $pincode
     * @param string $pensionNr
     * @param string $rijksregisterNr
     * @param string $syscardNr
     * @param string $driverLicense
     */
    public function __construct($sexType = null, $hasMedicalCertificate = null, $medicalCertificate = null, $civilState = null, $driverLicenseValid = null, $employed = null, $resigned = null, $fuelPumpRead = null, $aDRCertificate = null, $aDRCertificateValid = null, $applyGeneralCardInformation = null, $password = null, $antiTheftPassword = null, $pincode = null, $pensionNr = null, $rijksregisterNr = null, $syscardNr = null, $driverLicense = null)
    {
        $this
            ->setSexType($sexType)
            ->setHasMedicalCertificate($hasMedicalCertificate)
            ->setMedicalCertificate($medicalCertificate)
            ->setCivilState($civilState)
            ->setDriverLicenseValid($driverLicenseValid)
            ->setEmployed($employed)
            ->setResigned($resigned)
            ->setFuelPumpRead($fuelPumpRead)
            ->setADRCertificate($aDRCertificate)
            ->setADRCertificateValid($aDRCertificateValid)
            ->setApplyGeneralCardInformation($applyGeneralCardInformation)
            ->setPassword($password)
            ->setAntiTheftPassword($antiTheftPassword)
            ->setPincode($pincode)
            ->setPensionNr($pensionNr)
            ->setRijksregisterNr($rijksregisterNr)
            ->setSyscardNr($syscardNr)
            ->setDriverLicense($driverLicense);
    }
    /**
     * Get SexType value
     * @return string
     */
    public function getSexType()
    {
        return $this->SexType;
    }
    /**
     * Set SexType value
     * @uses \EnumType\EnumSexType::valueIsValid()
     * @uses \EnumType\EnumSexType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sexType
     * @return \StructType\PersonTechnicalInfo
     */
    public function setSexType($sexType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSexType::valueIsValid($sexType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sexType, implode(', ', \EnumType\EnumSexType::getValidValues())), __LINE__);
        }
        $this->SexType = $sexType;
        return $this;
    }
    /**
     * Get HasMedicalCertificate value
     * @return bool
     */
    public function getHasMedicalCertificate()
    {
        return $this->HasMedicalCertificate;
    }
    /**
     * Set HasMedicalCertificate value
     * @param bool $hasMedicalCertificate
     * @return \StructType\PersonTechnicalInfo
     */
    public function setHasMedicalCertificate($hasMedicalCertificate = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMedicalCertificate) && !is_bool($hasMedicalCertificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMedicalCertificate)), __LINE__);
        }
        $this->HasMedicalCertificate = $hasMedicalCertificate;
        return $this;
    }
    /**
     * Get MedicalCertificate value
     * @return string
     */
    public function getMedicalCertificate()
    {
        return $this->MedicalCertificate;
    }
    /**
     * Set MedicalCertificate value
     * @param string $medicalCertificate
     * @return \StructType\PersonTechnicalInfo
     */
    public function setMedicalCertificate($medicalCertificate = null)
    {
        // validation for constraint: string
        if (!is_null($medicalCertificate) && !is_string($medicalCertificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($medicalCertificate)), __LINE__);
        }
        $this->MedicalCertificate = $medicalCertificate;
        return $this;
    }
    /**
     * Get CivilState value
     * @return string
     */
    public function getCivilState()
    {
        return $this->CivilState;
    }
    /**
     * Set CivilState value
     * @uses \EnumType\EnumCivilState::valueIsValid()
     * @uses \EnumType\EnumCivilState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $civilState
     * @return \StructType\PersonTechnicalInfo
     */
    public function setCivilState($civilState = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCivilState::valueIsValid($civilState)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $civilState, implode(', ', \EnumType\EnumCivilState::getValidValues())), __LINE__);
        }
        $this->CivilState = $civilState;
        return $this;
    }
    /**
     * Get DriverLicenseValid value
     * @return string
     */
    public function getDriverLicenseValid()
    {
        return $this->DriverLicenseValid;
    }
    /**
     * Set DriverLicenseValid value
     * @param string $driverLicenseValid
     * @return \StructType\PersonTechnicalInfo
     */
    public function setDriverLicenseValid($driverLicenseValid = null)
    {
        // validation for constraint: string
        if (!is_null($driverLicenseValid) && !is_string($driverLicenseValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverLicenseValid)), __LINE__);
        }
        $this->DriverLicenseValid = $driverLicenseValid;
        return $this;
    }
    /**
     * Get Employed value
     * @return string
     */
    public function getEmployed()
    {
        return $this->Employed;
    }
    /**
     * Set Employed value
     * @param string $employed
     * @return \StructType\PersonTechnicalInfo
     */
    public function setEmployed($employed = null)
    {
        // validation for constraint: string
        if (!is_null($employed) && !is_string($employed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($employed)), __LINE__);
        }
        $this->Employed = $employed;
        return $this;
    }
    /**
     * Get Resigned value
     * @return string
     */
    public function getResigned()
    {
        return $this->Resigned;
    }
    /**
     * Set Resigned value
     * @param string $resigned
     * @return \StructType\PersonTechnicalInfo
     */
    public function setResigned($resigned = null)
    {
        // validation for constraint: string
        if (!is_null($resigned) && !is_string($resigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resigned)), __LINE__);
        }
        $this->Resigned = $resigned;
        return $this;
    }
    /**
     * Get FuelPumpRead value
     * @return bool
     */
    public function getFuelPumpRead()
    {
        return $this->FuelPumpRead;
    }
    /**
     * Set FuelPumpRead value
     * @param bool $fuelPumpRead
     * @return \StructType\PersonTechnicalInfo
     */
    public function setFuelPumpRead($fuelPumpRead = null)
    {
        // validation for constraint: boolean
        if (!is_null($fuelPumpRead) && !is_bool($fuelPumpRead)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fuelPumpRead)), __LINE__);
        }
        $this->FuelPumpRead = $fuelPumpRead;
        return $this;
    }
    /**
     * Get ADRCertificate value
     * @return bool
     */
    public function getADRCertificate()
    {
        return $this->ADRCertificate;
    }
    /**
     * Set ADRCertificate value
     * @param bool $aDRCertificate
     * @return \StructType\PersonTechnicalInfo
     */
    public function setADRCertificate($aDRCertificate = null)
    {
        // validation for constraint: boolean
        if (!is_null($aDRCertificate) && !is_bool($aDRCertificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aDRCertificate)), __LINE__);
        }
        $this->ADRCertificate = $aDRCertificate;
        return $this;
    }
    /**
     * Get ADRCertificateValid value
     * @return string
     */
    public function getADRCertificateValid()
    {
        return $this->ADRCertificateValid;
    }
    /**
     * Set ADRCertificateValid value
     * @param string $aDRCertificateValid
     * @return \StructType\PersonTechnicalInfo
     */
    public function setADRCertificateValid($aDRCertificateValid = null)
    {
        // validation for constraint: string
        if (!is_null($aDRCertificateValid) && !is_string($aDRCertificateValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aDRCertificateValid)), __LINE__);
        }
        $this->ADRCertificateValid = $aDRCertificateValid;
        return $this;
    }
    /**
     * Get ApplyGeneralCardInformation value
     * @return bool
     */
    public function getApplyGeneralCardInformation()
    {
        return $this->ApplyGeneralCardInformation;
    }
    /**
     * Set ApplyGeneralCardInformation value
     * @param bool $applyGeneralCardInformation
     * @return \StructType\PersonTechnicalInfo
     */
    public function setApplyGeneralCardInformation($applyGeneralCardInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyGeneralCardInformation) && !is_bool($applyGeneralCardInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($applyGeneralCardInformation)), __LINE__);
        }
        $this->ApplyGeneralCardInformation = $applyGeneralCardInformation;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\PersonTechnicalInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get AntiTheftPassword value
     * @return string|null
     */
    public function getAntiTheftPassword()
    {
        return $this->AntiTheftPassword;
    }
    /**
     * Set AntiTheftPassword value
     * @param string $antiTheftPassword
     * @return \StructType\PersonTechnicalInfo
     */
    public function setAntiTheftPassword($antiTheftPassword = null)
    {
        // validation for constraint: string
        if (!is_null($antiTheftPassword) && !is_string($antiTheftPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($antiTheftPassword)), __LINE__);
        }
        $this->AntiTheftPassword = $antiTheftPassword;
        return $this;
    }
    /**
     * Get Pincode value
     * @return string|null
     */
    public function getPincode()
    {
        return $this->Pincode;
    }
    /**
     * Set Pincode value
     * @param string $pincode
     * @return \StructType\PersonTechnicalInfo
     */
    public function setPincode($pincode = null)
    {
        // validation for constraint: string
        if (!is_null($pincode) && !is_string($pincode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pincode)), __LINE__);
        }
        $this->Pincode = $pincode;
        return $this;
    }
    /**
     * Get PensionNr value
     * @return string|null
     */
    public function getPensionNr()
    {
        return $this->PensionNr;
    }
    /**
     * Set PensionNr value
     * @param string $pensionNr
     * @return \StructType\PersonTechnicalInfo
     */
    public function setPensionNr($pensionNr = null)
    {
        // validation for constraint: string
        if (!is_null($pensionNr) && !is_string($pensionNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pensionNr)), __LINE__);
        }
        $this->PensionNr = $pensionNr;
        return $this;
    }
    /**
     * Get RijksregisterNr value
     * @return string|null
     */
    public function getRijksregisterNr()
    {
        return $this->RijksregisterNr;
    }
    /**
     * Set RijksregisterNr value
     * @param string $rijksregisterNr
     * @return \StructType\PersonTechnicalInfo
     */
    public function setRijksregisterNr($rijksregisterNr = null)
    {
        // validation for constraint: string
        if (!is_null($rijksregisterNr) && !is_string($rijksregisterNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rijksregisterNr)), __LINE__);
        }
        $this->RijksregisterNr = $rijksregisterNr;
        return $this;
    }
    /**
     * Get SyscardNr value
     * @return string|null
     */
    public function getSyscardNr()
    {
        return $this->SyscardNr;
    }
    /**
     * Set SyscardNr value
     * @param string $syscardNr
     * @return \StructType\PersonTechnicalInfo
     */
    public function setSyscardNr($syscardNr = null)
    {
        // validation for constraint: string
        if (!is_null($syscardNr) && !is_string($syscardNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($syscardNr)), __LINE__);
        }
        $this->SyscardNr = $syscardNr;
        return $this;
    }
    /**
     * Get DriverLicense value
     * @return string|null
     */
    public function getDriverLicense()
    {
        return $this->DriverLicense;
    }
    /**
     * Set DriverLicense value
     * @param string $driverLicense
     * @return \StructType\PersonTechnicalInfo
     */
    public function setDriverLicense($driverLicense = null)
    {
        // validation for constraint: string
        if (!is_null($driverLicense) && !is_string($driverLicense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverLicense)), __LINE__);
        }
        $this->DriverLicense = $driverLicense;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonTechnicalInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
