<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonSelection StructType
 * @subpackage Structs
 */
class PersonSelection extends AbstractStructBase
{
    /**
     * The IncludeContactInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeContactInfo;
    /**
     * The IncludePrivateInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludePrivateInfo;
    /**
     * The IncludeTechnicalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeTechnicalInfo;
    /**
     * The IncludeTotalKms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeTotalKms;
    /**
     * The IncludeLastVehicleInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeLastVehicleInfo;
    /**
     * The IncludeSiteInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeSiteInfo;
    /**
     * The IncludePicture
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludePicture;
    /**
     * The IncludeResponsible
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeResponsible;
    /**
     * The IncludeTachoCardInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeTachoCardInfo;
    /**
     * The DateTimeRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRange;
    /**
     * The SelectionFromToday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSelection
     */
    public $SelectionFromToday;
    /**
     * The Persons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Persons;
    /**
     * Constructor method for PersonSelection
     * @uses PersonSelection::setIncludeContactInfo()
     * @uses PersonSelection::setIncludePrivateInfo()
     * @uses PersonSelection::setIncludeTechnicalInfo()
     * @uses PersonSelection::setIncludeTotalKms()
     * @uses PersonSelection::setIncludeLastVehicleInfo()
     * @uses PersonSelection::setIncludeSiteInfo()
     * @uses PersonSelection::setIncludePicture()
     * @uses PersonSelection::setIncludeResponsible()
     * @uses PersonSelection::setIncludeTachoCardInfo()
     * @uses PersonSelection::setDateTimeRange()
     * @uses PersonSelection::setSelectionFromToday()
     * @uses PersonSelection::setPersons()
     * @param bool $includeContactInfo
     * @param bool $includePrivateInfo
     * @param bool $includeTechnicalInfo
     * @param bool $includeTotalKms
     * @param bool $includeLastVehicleInfo
     * @param bool $includeSiteInfo
     * @param bool $includePicture
     * @param bool $includeResponsible
     * @param bool $includeTachoCardInfo
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @param \ArrayType\ArrayOfIdentifier $persons
     */
    public function __construct($includeContactInfo = null, $includePrivateInfo = null, $includeTechnicalInfo = null, $includeTotalKms = null, $includeLastVehicleInfo = null, $includeSiteInfo = null, $includePicture = null, $includeResponsible = null, $includeTachoCardInfo = null, \StructType\DateTimeRangeSelection $dateTimeRange = null, \StructType\DateTimeSelection $selectionFromToday = null, \ArrayType\ArrayOfIdentifier $persons = null)
    {
        $this
            ->setIncludeContactInfo($includeContactInfo)
            ->setIncludePrivateInfo($includePrivateInfo)
            ->setIncludeTechnicalInfo($includeTechnicalInfo)
            ->setIncludeTotalKms($includeTotalKms)
            ->setIncludeLastVehicleInfo($includeLastVehicleInfo)
            ->setIncludeSiteInfo($includeSiteInfo)
            ->setIncludePicture($includePicture)
            ->setIncludeResponsible($includeResponsible)
            ->setIncludeTachoCardInfo($includeTachoCardInfo)
            ->setDateTimeRange($dateTimeRange)
            ->setSelectionFromToday($selectionFromToday)
            ->setPersons($persons);
    }
    /**
     * Get IncludeContactInfo value
     * @return bool
     */
    public function getIncludeContactInfo()
    {
        return $this->IncludeContactInfo;
    }
    /**
     * Set IncludeContactInfo value
     * @param bool $includeContactInfo
     * @return \StructType\PersonSelection
     */
    public function setIncludeContactInfo($includeContactInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeContactInfo) && !is_bool($includeContactInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeContactInfo)), __LINE__);
        }
        $this->IncludeContactInfo = $includeContactInfo;
        return $this;
    }
    /**
     * Get IncludePrivateInfo value
     * @return bool
     */
    public function getIncludePrivateInfo()
    {
        return $this->IncludePrivateInfo;
    }
    /**
     * Set IncludePrivateInfo value
     * @param bool $includePrivateInfo
     * @return \StructType\PersonSelection
     */
    public function setIncludePrivateInfo($includePrivateInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePrivateInfo) && !is_bool($includePrivateInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includePrivateInfo)), __LINE__);
        }
        $this->IncludePrivateInfo = $includePrivateInfo;
        return $this;
    }
    /**
     * Get IncludeTechnicalInfo value
     * @return bool
     */
    public function getIncludeTechnicalInfo()
    {
        return $this->IncludeTechnicalInfo;
    }
    /**
     * Set IncludeTechnicalInfo value
     * @param bool $includeTechnicalInfo
     * @return \StructType\PersonSelection
     */
    public function setIncludeTechnicalInfo($includeTechnicalInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTechnicalInfo) && !is_bool($includeTechnicalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTechnicalInfo)), __LINE__);
        }
        $this->IncludeTechnicalInfo = $includeTechnicalInfo;
        return $this;
    }
    /**
     * Get IncludeTotalKms value
     * @return bool
     */
    public function getIncludeTotalKms()
    {
        return $this->IncludeTotalKms;
    }
    /**
     * Set IncludeTotalKms value
     * @param bool $includeTotalKms
     * @return \StructType\PersonSelection
     */
    public function setIncludeTotalKms($includeTotalKms = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTotalKms) && !is_bool($includeTotalKms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTotalKms)), __LINE__);
        }
        $this->IncludeTotalKms = $includeTotalKms;
        return $this;
    }
    /**
     * Get IncludeLastVehicleInfo value
     * @return bool
     */
    public function getIncludeLastVehicleInfo()
    {
        return $this->IncludeLastVehicleInfo;
    }
    /**
     * Set IncludeLastVehicleInfo value
     * @param bool $includeLastVehicleInfo
     * @return \StructType\PersonSelection
     */
    public function setIncludeLastVehicleInfo($includeLastVehicleInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeLastVehicleInfo) && !is_bool($includeLastVehicleInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeLastVehicleInfo)), __LINE__);
        }
        $this->IncludeLastVehicleInfo = $includeLastVehicleInfo;
        return $this;
    }
    /**
     * Get IncludeSiteInfo value
     * @return bool
     */
    public function getIncludeSiteInfo()
    {
        return $this->IncludeSiteInfo;
    }
    /**
     * Set IncludeSiteInfo value
     * @param bool $includeSiteInfo
     * @return \StructType\PersonSelection
     */
    public function setIncludeSiteInfo($includeSiteInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSiteInfo) && !is_bool($includeSiteInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeSiteInfo)), __LINE__);
        }
        $this->IncludeSiteInfo = $includeSiteInfo;
        return $this;
    }
    /**
     * Get IncludePicture value
     * @return bool
     */
    public function getIncludePicture()
    {
        return $this->IncludePicture;
    }
    /**
     * Set IncludePicture value
     * @param bool $includePicture
     * @return \StructType\PersonSelection
     */
    public function setIncludePicture($includePicture = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePicture) && !is_bool($includePicture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includePicture)), __LINE__);
        }
        $this->IncludePicture = $includePicture;
        return $this;
    }
    /**
     * Get IncludeResponsible value
     * @return bool
     */
    public function getIncludeResponsible()
    {
        return $this->IncludeResponsible;
    }
    /**
     * Set IncludeResponsible value
     * @param bool $includeResponsible
     * @return \StructType\PersonSelection
     */
    public function setIncludeResponsible($includeResponsible = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeResponsible) && !is_bool($includeResponsible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeResponsible)), __LINE__);
        }
        $this->IncludeResponsible = $includeResponsible;
        return $this;
    }
    /**
     * Get IncludeTachoCardInfo value
     * @return bool
     */
    public function getIncludeTachoCardInfo()
    {
        return $this->IncludeTachoCardInfo;
    }
    /**
     * Set IncludeTachoCardInfo value
     * @param bool $includeTachoCardInfo
     * @return \StructType\PersonSelection
     */
    public function setIncludeTachoCardInfo($includeTachoCardInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTachoCardInfo) && !is_bool($includeTachoCardInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTachoCardInfo)), __LINE__);
        }
        $this->IncludeTachoCardInfo = $includeTachoCardInfo;
        return $this;
    }
    /**
     * Get DateTimeRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRange()
    {
        return $this->DateTimeRange;
    }
    /**
     * Set DateTimeRange value
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @return \StructType\PersonSelection
     */
    public function setDateTimeRange(\StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this->DateTimeRange = $dateTimeRange;
        return $this;
    }
    /**
     * Get SelectionFromToday value
     * @return \StructType\DateTimeSelection|null
     */
    public function getSelectionFromToday()
    {
        return $this->SelectionFromToday;
    }
    /**
     * Set SelectionFromToday value
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @return \StructType\PersonSelection
     */
    public function setSelectionFromToday(\StructType\DateTimeSelection $selectionFromToday = null)
    {
        $this->SelectionFromToday = $selectionFromToday;
        return $this;
    }
    /**
     * Get Persons value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getPersons()
    {
        return $this->Persons;
    }
    /**
     * Set Persons value
     * @param \ArrayType\ArrayOfIdentifier $persons
     * @return \StructType\PersonSelection
     */
    public function setPersons(\ArrayType\ArrayOfIdentifier $persons = null)
    {
        $this->Persons = $persons;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
