<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonResult_V2 StructType
 * @subpackage Structs
 */
class PersonResult_V2 extends Person_V2
{
    /**
     * The PersonTransicsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonTransicsID;
    /**
     * The Modification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modification;
    /**
     * The TotalKms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TotalKms;
    /**
     * The LastVehicleInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LastVehicleInfo
     */
    public $LastVehicleInfo;
    /**
     * The Site
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierResult
     */
    public $Site;
    /**
     * The Responsible
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Responsible;
    /**
     * The TachoCardInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TachoCardInfo
     */
    public $TachoCardInfo;
    /**
     * The Registrations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonRegistrations
     */
    public $Registrations;
    /**
     * Constructor method for PersonResult_V2
     * @uses PersonResult_V2::setPersonTransicsID()
     * @uses PersonResult_V2::setModification()
     * @uses PersonResult_V2::setTotalKms()
     * @uses PersonResult_V2::setLastVehicleInfo()
     * @uses PersonResult_V2::setSite()
     * @uses PersonResult_V2::setResponsible()
     * @uses PersonResult_V2::setTachoCardInfo()
     * @uses PersonResult_V2::setRegistrations()
     * @param int $personTransicsID
     * @param string $modification
     * @param int $totalKms
     * @param \StructType\LastVehicleInfo $lastVehicleInfo
     * @param \StructType\IdentifierResult $site
     * @param \StructType\IdentifierPerson $responsible
     * @param \StructType\TachoCardInfo $tachoCardInfo
     * @param \StructType\PersonRegistrations $registrations
     */
    public function __construct($personTransicsID = null, $modification = null, $totalKms = null, \StructType\LastVehicleInfo $lastVehicleInfo = null, \StructType\IdentifierResult $site = null, \StructType\IdentifierPerson $responsible = null, \StructType\TachoCardInfo $tachoCardInfo = null, \StructType\PersonRegistrations $registrations = null)
    {
        $this
            ->setPersonTransicsID($personTransicsID)
            ->setModification($modification)
            ->setTotalKms($totalKms)
            ->setLastVehicleInfo($lastVehicleInfo)
            ->setSite($site)
            ->setResponsible($responsible)
            ->setTachoCardInfo($tachoCardInfo)
            ->setRegistrations($registrations);
    }
    /**
     * Get PersonTransicsID value
     * @return int
     */
    public function getPersonTransicsID()
    {
        return $this->PersonTransicsID;
    }
    /**
     * Set PersonTransicsID value
     * @param int $personTransicsID
     * @return \StructType\PersonResult_V2
     */
    public function setPersonTransicsID($personTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($personTransicsID) && !is_numeric($personTransicsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personTransicsID)), __LINE__);
        }
        $this->PersonTransicsID = $personTransicsID;
        return $this;
    }
    /**
     * Get Modification value
     * @return string
     */
    public function getModification()
    {
        return $this->Modification;
    }
    /**
     * Set Modification value
     * @param string $modification
     * @return \StructType\PersonResult_V2
     */
    public function setModification($modification = null)
    {
        // validation for constraint: string
        if (!is_null($modification) && !is_string($modification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modification)), __LINE__);
        }
        $this->Modification = $modification;
        return $this;
    }
    /**
     * Get TotalKms value
     * @return int
     */
    public function getTotalKms()
    {
        return $this->TotalKms;
    }
    /**
     * Set TotalKms value
     * @param int $totalKms
     * @return \StructType\PersonResult_V2
     */
    public function setTotalKms($totalKms = null)
    {
        // validation for constraint: int
        if (!is_null($totalKms) && !is_numeric($totalKms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalKms)), __LINE__);
        }
        $this->TotalKms = $totalKms;
        return $this;
    }
    /**
     * Get LastVehicleInfo value
     * @return \StructType\LastVehicleInfo|null
     */
    public function getLastVehicleInfo()
    {
        return $this->LastVehicleInfo;
    }
    /**
     * Set LastVehicleInfo value
     * @param \StructType\LastVehicleInfo $lastVehicleInfo
     * @return \StructType\PersonResult_V2
     */
    public function setLastVehicleInfo(\StructType\LastVehicleInfo $lastVehicleInfo = null)
    {
        $this->LastVehicleInfo = $lastVehicleInfo;
        return $this;
    }
    /**
     * Get Site value
     * @return \StructType\IdentifierResult|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\IdentifierResult $site
     * @return \StructType\PersonResult_V2
     */
    public function setSite(\StructType\IdentifierResult $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Responsible value
     * @return \StructType\IdentifierPerson|null
     */
    public function getResponsible()
    {
        return $this->Responsible;
    }
    /**
     * Set Responsible value
     * @param \StructType\IdentifierPerson $responsible
     * @return \StructType\PersonResult_V2
     */
    public function setResponsible(\StructType\IdentifierPerson $responsible = null)
    {
        $this->Responsible = $responsible;
        return $this;
    }
    /**
     * Get TachoCardInfo value
     * @return \StructType\TachoCardInfo|null
     */
    public function getTachoCardInfo()
    {
        return $this->TachoCardInfo;
    }
    /**
     * Set TachoCardInfo value
     * @param \StructType\TachoCardInfo $tachoCardInfo
     * @return \StructType\PersonResult_V2
     */
    public function setTachoCardInfo(\StructType\TachoCardInfo $tachoCardInfo = null)
    {
        $this->TachoCardInfo = $tachoCardInfo;
        return $this;
    }
    /**
     * Get Registrations value
     * @return \StructType\PersonRegistrations|null
     */
    public function getRegistrations()
    {
        return $this->Registrations;
    }
    /**
     * Set Registrations value
     * @param \StructType\PersonRegistrations $registrations
     * @return \StructType\PersonResult_V2
     */
    public function setRegistrations(\StructType\PersonRegistrations $registrations = null)
    {
        $this->Registrations = $registrations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonResult_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
