<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonPrivateInfo StructType
 * @subpackage Structs
 */
class PersonPrivateInfo extends AbstractStructBase
{
    /**
     * The Birthday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Birthday;
    /**
     * The BirthdaySpouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BirthdaySpouse;
    /**
     * The CountOfChildren
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CountOfChildren;
    /**
     * The ProfessionSpouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfessionSpouse;
    /**
     * The NameSpouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameSpouse;
    /**
     * The ZipcodeOfBirthCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipcodeOfBirthCity;
    /**
     * The CountryCodeOfBirthCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCodeOfBirthCity;
    /**
     * The ZipcodeOfBirthCitySpouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipcodeOfBirthCitySpouse;
    /**
     * The CountryCodeOfBirthCitySpouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCodeOfBirthCitySpouse;
    /**
     * Constructor method for PersonPrivateInfo
     * @uses PersonPrivateInfo::setBirthday()
     * @uses PersonPrivateInfo::setBirthdaySpouse()
     * @uses PersonPrivateInfo::setCountOfChildren()
     * @uses PersonPrivateInfo::setProfessionSpouse()
     * @uses PersonPrivateInfo::setNameSpouse()
     * @uses PersonPrivateInfo::setZipcodeOfBirthCity()
     * @uses PersonPrivateInfo::setCountryCodeOfBirthCity()
     * @uses PersonPrivateInfo::setZipcodeOfBirthCitySpouse()
     * @uses PersonPrivateInfo::setCountryCodeOfBirthCitySpouse()
     * @param string $birthday
     * @param string $birthdaySpouse
     * @param int $countOfChildren
     * @param string $professionSpouse
     * @param string $nameSpouse
     * @param string $zipcodeOfBirthCity
     * @param string $countryCodeOfBirthCity
     * @param string $zipcodeOfBirthCitySpouse
     * @param string $countryCodeOfBirthCitySpouse
     */
    public function __construct($birthday = null, $birthdaySpouse = null, $countOfChildren = null, $professionSpouse = null, $nameSpouse = null, $zipcodeOfBirthCity = null, $countryCodeOfBirthCity = null, $zipcodeOfBirthCitySpouse = null, $countryCodeOfBirthCitySpouse = null)
    {
        $this
            ->setBirthday($birthday)
            ->setBirthdaySpouse($birthdaySpouse)
            ->setCountOfChildren($countOfChildren)
            ->setProfessionSpouse($professionSpouse)
            ->setNameSpouse($nameSpouse)
            ->setZipcodeOfBirthCity($zipcodeOfBirthCity)
            ->setCountryCodeOfBirthCity($countryCodeOfBirthCity)
            ->setZipcodeOfBirthCitySpouse($zipcodeOfBirthCitySpouse)
            ->setCountryCodeOfBirthCitySpouse($countryCodeOfBirthCitySpouse);
    }
    /**
     * Get Birthday value
     * @return string
     */
    public function getBirthday()
    {
        return $this->Birthday;
    }
    /**
     * Set Birthday value
     * @param string $birthday
     * @return \StructType\PersonPrivateInfo
     */
    public function setBirthday($birthday = null)
    {
        // validation for constraint: string
        if (!is_null($birthday) && !is_string($birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthday)), __LINE__);
        }
        $this->Birthday = $birthday;
        return $this;
    }
    /**
     * Get BirthdaySpouse value
     * @return string
     */
    public function getBirthdaySpouse()
    {
        return $this->BirthdaySpouse;
    }
    /**
     * Set BirthdaySpouse value
     * @param string $birthdaySpouse
     * @return \StructType\PersonPrivateInfo
     */
    public function setBirthdaySpouse($birthdaySpouse = null)
    {
        // validation for constraint: string
        if (!is_null($birthdaySpouse) && !is_string($birthdaySpouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthdaySpouse)), __LINE__);
        }
        $this->BirthdaySpouse = $birthdaySpouse;
        return $this;
    }
    /**
     * Get CountOfChildren value
     * @return int
     */
    public function getCountOfChildren()
    {
        return $this->CountOfChildren;
    }
    /**
     * Set CountOfChildren value
     * @param int $countOfChildren
     * @return \StructType\PersonPrivateInfo
     */
    public function setCountOfChildren($countOfChildren = null)
    {
        // validation for constraint: int
        if (!is_null($countOfChildren) && !is_numeric($countOfChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($countOfChildren)), __LINE__);
        }
        $this->CountOfChildren = $countOfChildren;
        return $this;
    }
    /**
     * Get ProfessionSpouse value
     * @return string|null
     */
    public function getProfessionSpouse()
    {
        return $this->ProfessionSpouse;
    }
    /**
     * Set ProfessionSpouse value
     * @param string $professionSpouse
     * @return \StructType\PersonPrivateInfo
     */
    public function setProfessionSpouse($professionSpouse = null)
    {
        // validation for constraint: string
        if (!is_null($professionSpouse) && !is_string($professionSpouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($professionSpouse)), __LINE__);
        }
        $this->ProfessionSpouse = $professionSpouse;
        return $this;
    }
    /**
     * Get NameSpouse value
     * @return string|null
     */
    public function getNameSpouse()
    {
        return $this->NameSpouse;
    }
    /**
     * Set NameSpouse value
     * @param string $nameSpouse
     * @return \StructType\PersonPrivateInfo
     */
    public function setNameSpouse($nameSpouse = null)
    {
        // validation for constraint: string
        if (!is_null($nameSpouse) && !is_string($nameSpouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameSpouse)), __LINE__);
        }
        $this->NameSpouse = $nameSpouse;
        return $this;
    }
    /**
     * Get ZipcodeOfBirthCity value
     * @return string|null
     */
    public function getZipcodeOfBirthCity()
    {
        return $this->ZipcodeOfBirthCity;
    }
    /**
     * Set ZipcodeOfBirthCity value
     * @param string $zipcodeOfBirthCity
     * @return \StructType\PersonPrivateInfo
     */
    public function setZipcodeOfBirthCity($zipcodeOfBirthCity = null)
    {
        // validation for constraint: string
        if (!is_null($zipcodeOfBirthCity) && !is_string($zipcodeOfBirthCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipcodeOfBirthCity)), __LINE__);
        }
        $this->ZipcodeOfBirthCity = $zipcodeOfBirthCity;
        return $this;
    }
    /**
     * Get CountryCodeOfBirthCity value
     * @return string|null
     */
    public function getCountryCodeOfBirthCity()
    {
        return $this->CountryCodeOfBirthCity;
    }
    /**
     * Set CountryCodeOfBirthCity value
     * @param string $countryCodeOfBirthCity
     * @return \StructType\PersonPrivateInfo
     */
    public function setCountryCodeOfBirthCity($countryCodeOfBirthCity = null)
    {
        // validation for constraint: string
        if (!is_null($countryCodeOfBirthCity) && !is_string($countryCodeOfBirthCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCodeOfBirthCity)), __LINE__);
        }
        $this->CountryCodeOfBirthCity = $countryCodeOfBirthCity;
        return $this;
    }
    /**
     * Get ZipcodeOfBirthCitySpouse value
     * @return string|null
     */
    public function getZipcodeOfBirthCitySpouse()
    {
        return $this->ZipcodeOfBirthCitySpouse;
    }
    /**
     * Set ZipcodeOfBirthCitySpouse value
     * @param string $zipcodeOfBirthCitySpouse
     * @return \StructType\PersonPrivateInfo
     */
    public function setZipcodeOfBirthCitySpouse($zipcodeOfBirthCitySpouse = null)
    {
        // validation for constraint: string
        if (!is_null($zipcodeOfBirthCitySpouse) && !is_string($zipcodeOfBirthCitySpouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipcodeOfBirthCitySpouse)), __LINE__);
        }
        $this->ZipcodeOfBirthCitySpouse = $zipcodeOfBirthCitySpouse;
        return $this;
    }
    /**
     * Get CountryCodeOfBirthCitySpouse value
     * @return string|null
     */
    public function getCountryCodeOfBirthCitySpouse()
    {
        return $this->CountryCodeOfBirthCitySpouse;
    }
    /**
     * Set CountryCodeOfBirthCitySpouse value
     * @param string $countryCodeOfBirthCitySpouse
     * @return \StructType\PersonPrivateInfo
     */
    public function setCountryCodeOfBirthCitySpouse($countryCodeOfBirthCitySpouse = null)
    {
        // validation for constraint: string
        if (!is_null($countryCodeOfBirthCitySpouse) && !is_string($countryCodeOfBirthCitySpouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCodeOfBirthCitySpouse)), __LINE__);
        }
        $this->CountryCodeOfBirthCitySpouse = $countryCodeOfBirthCitySpouse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonPrivateInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
