<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonLanguages StructType
 * @subpackage Structs
 */
class PersonLanguages extends AbstractStructBase
{
    /**
     * The WorkingLanguage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkingLanguage;
    /**
     * The UserInterfaceLanguage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserInterfaceLanguage;
    /**
     * The ObcUILanguage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObcUILanguage;
    /**
     * The ObcInstructionSetLanguage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObcInstructionSetLanguage;
    /**
     * The ObcNavigationUILanguage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObcNavigationUILanguage;
    /**
     * The ObcNavigationSpeechLanguage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObcNavigationSpeechLanguage;
    /**
     * Constructor method for PersonLanguages
     * @uses PersonLanguages::setWorkingLanguage()
     * @uses PersonLanguages::setUserInterfaceLanguage()
     * @uses PersonLanguages::setObcUILanguage()
     * @uses PersonLanguages::setObcInstructionSetLanguage()
     * @uses PersonLanguages::setObcNavigationUILanguage()
     * @uses PersonLanguages::setObcNavigationSpeechLanguage()
     * @param string $workingLanguage
     * @param string $userInterfaceLanguage
     * @param string $obcUILanguage
     * @param string $obcInstructionSetLanguage
     * @param string $obcNavigationUILanguage
     * @param string $obcNavigationSpeechLanguage
     */
    public function __construct($workingLanguage = null, $userInterfaceLanguage = null, $obcUILanguage = null, $obcInstructionSetLanguage = null, $obcNavigationUILanguage = null, $obcNavigationSpeechLanguage = null)
    {
        $this
            ->setWorkingLanguage($workingLanguage)
            ->setUserInterfaceLanguage($userInterfaceLanguage)
            ->setObcUILanguage($obcUILanguage)
            ->setObcInstructionSetLanguage($obcInstructionSetLanguage)
            ->setObcNavigationUILanguage($obcNavigationUILanguage)
            ->setObcNavigationSpeechLanguage($obcNavigationSpeechLanguage);
    }
    /**
     * Get WorkingLanguage value
     * @return string|null
     */
    public function getWorkingLanguage()
    {
        return $this->WorkingLanguage;
    }
    /**
     * Set WorkingLanguage value
     * @param string $workingLanguage
     * @return \StructType\PersonLanguages
     */
    public function setWorkingLanguage($workingLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($workingLanguage) && !is_string($workingLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workingLanguage)), __LINE__);
        }
        $this->WorkingLanguage = $workingLanguage;
        return $this;
    }
    /**
     * Get UserInterfaceLanguage value
     * @return string|null
     */
    public function getUserInterfaceLanguage()
    {
        return $this->UserInterfaceLanguage;
    }
    /**
     * Set UserInterfaceLanguage value
     * @param string $userInterfaceLanguage
     * @return \StructType\PersonLanguages
     */
    public function setUserInterfaceLanguage($userInterfaceLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($userInterfaceLanguage) && !is_string($userInterfaceLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userInterfaceLanguage)), __LINE__);
        }
        $this->UserInterfaceLanguage = $userInterfaceLanguage;
        return $this;
    }
    /**
     * Get ObcUILanguage value
     * @return string|null
     */
    public function getObcUILanguage()
    {
        return $this->ObcUILanguage;
    }
    /**
     * Set ObcUILanguage value
     * @param string $obcUILanguage
     * @return \StructType\PersonLanguages
     */
    public function setObcUILanguage($obcUILanguage = null)
    {
        // validation for constraint: string
        if (!is_null($obcUILanguage) && !is_string($obcUILanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obcUILanguage)), __LINE__);
        }
        $this->ObcUILanguage = $obcUILanguage;
        return $this;
    }
    /**
     * Get ObcInstructionSetLanguage value
     * @return string|null
     */
    public function getObcInstructionSetLanguage()
    {
        return $this->ObcInstructionSetLanguage;
    }
    /**
     * Set ObcInstructionSetLanguage value
     * @param string $obcInstructionSetLanguage
     * @return \StructType\PersonLanguages
     */
    public function setObcInstructionSetLanguage($obcInstructionSetLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($obcInstructionSetLanguage) && !is_string($obcInstructionSetLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obcInstructionSetLanguage)), __LINE__);
        }
        $this->ObcInstructionSetLanguage = $obcInstructionSetLanguage;
        return $this;
    }
    /**
     * Get ObcNavigationUILanguage value
     * @return string|null
     */
    public function getObcNavigationUILanguage()
    {
        return $this->ObcNavigationUILanguage;
    }
    /**
     * Set ObcNavigationUILanguage value
     * @param string $obcNavigationUILanguage
     * @return \StructType\PersonLanguages
     */
    public function setObcNavigationUILanguage($obcNavigationUILanguage = null)
    {
        // validation for constraint: string
        if (!is_null($obcNavigationUILanguage) && !is_string($obcNavigationUILanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obcNavigationUILanguage)), __LINE__);
        }
        $this->ObcNavigationUILanguage = $obcNavigationUILanguage;
        return $this;
    }
    /**
     * Get ObcNavigationSpeechLanguage value
     * @return string|null
     */
    public function getObcNavigationSpeechLanguage()
    {
        return $this->ObcNavigationSpeechLanguage;
    }
    /**
     * Set ObcNavigationSpeechLanguage value
     * @param string $obcNavigationSpeechLanguage
     * @return \StructType\PersonLanguages
     */
    public function setObcNavigationSpeechLanguage($obcNavigationSpeechLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($obcNavigationSpeechLanguage) && !is_string($obcNavigationSpeechLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obcNavigationSpeechLanguage)), __LINE__);
        }
        $this->ObcNavigationSpeechLanguage = $obcNavigationSpeechLanguage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonLanguages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
