<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Path StructType
 * @subpackage Structs
 */
class Path extends PathBase
{
    /**
     * The Visible
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Visible;
    /**
     * The Answers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnswer
     */
    public $Answers;
    /**
     * Constructor method for Path
     * @uses Path::setVisible()
     * @uses Path::setAnswers()
     * @param bool $visible
     * @param \ArrayType\ArrayOfAnswer $answers
     */
    public function __construct($visible = null, \ArrayType\ArrayOfAnswer $answers = null)
    {
        $this
            ->setVisible($visible)
            ->setAnswers($answers);
    }
    /**
     * Get Visible value
     * @return bool
     */
    public function getVisible()
    {
        return $this->Visible;
    }
    /**
     * Set Visible value
     * @param bool $visible
     * @return \StructType\Path
     */
    public function setVisible($visible = null)
    {
        // validation for constraint: boolean
        if (!is_null($visible) && !is_bool($visible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($visible)), __LINE__);
        }
        $this->Visible = $visible;
        return $this;
    }
    /**
     * Get Answers value
     * @return \ArrayType\ArrayOfAnswer|null
     */
    public function getAnswers()
    {
        return $this->Answers;
    }
    /**
     * Set Answers value
     * @param \ArrayType\ArrayOfAnswer $answers
     * @return \StructType\Path
     */
    public function setAnswers(\ArrayType\ArrayOfAnswer $answers = null)
    {
        $this->Answers = $answers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Path
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
